/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.util.io.UTF8StringBuilderOutputStream;

public class OutputPort
extends Datum {
    private PrintStream lineWriter;
    private boolean standard;
    private boolean closed = false;
    private UTF8StringBuilderOutputStream stringPort;
    private LispMessage msg;

    private OutputPort(OutputStream wr, boolean std, LispMessage msg) {
        this.lineWriter = wr instanceof PrintStream ? (PrintStream)wr : new PrintStream(wr);
        this.standard = std;
        this.msg = msg;
        this.stringPort = wr instanceof UTF8StringBuilderOutputStream ? (UTF8StringBuilderOutputStream)wr : null;
    }

    public OutputPort(PrintStream wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(OutputStream wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(File fname, LispMessage msg) {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream(wr);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public OutputPort(File fname, String encoding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream((OutputStream)wr, true, encoding);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    static OutputPort getStringPort(LispMessage msg) {
        return new OutputPort(new UTF8StringBuilderOutputStream(), false, msg);
    }

    public static OutputPort getStandard(LispMessage msg) {
        return new OutputPort(System.out, true, msg);
    }

    public void writeChar(LispCharacter ch) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(ch.getCharacter());
        } else {
            this.lineWriter.print(ch.getCharacter());
        }
    }

    public void write(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.getResultWithoutSS(d));
        } else {
            this.lineWriter.print(LispUtils.getResultWithoutSS(d));
        }
    }

    public void display(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.print(d));
        } else {
            this.lineWriter.print(LispUtils.print(d));
        }
    }

    public void writeWithSS(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.getResult(d));
        } else {
            this.lineWriter.print(LispUtils.getResult(d));
        }
    }

    public void newline() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.println();
        } else {
            this.lineWriter.println();
        }
    }

    public void close() {
        if (!this.closed && !this.standard) {
            this.lineWriter.close();
            this.closed = true;
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    public boolean isTypePort() {
        return true;
    }

    public boolean isStringPort() {
        return this.stringPort != null;
    }

    public Writer getWriter() {
        return new OutputStreamWriter(this.lineWriter);
    }

    public String getOutputString() {
        if (this.isStringPort()) {
            return new String(this.stringPort.toString());
        }
        throw new IllegalStateException();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<oport>");
    }
}

