/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.Math2;

public final class LispMath {
    private static final LispNumber TWO_I = LispComplex.newComplex(0.0, 2.0);
    private static final LispNumber N_INF_PI_HALF_I = LispComplex.newComplex(Double.NEGATIVE_INFINITY, -1.5707963267948966);
    private static final Double P_ZERO = new Double(0.0);
    private static final Double M_ZERO = new Double(-0.0);
    private static final BigInteger LIMIT_NRT = BigInteger.valueOf(256L);
    private static final BigInteger LIMIT_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger DEG_ALL = BigInteger.valueOf(360L);
    public static final LispDouble INEXACT_PI = new LispDouble(Math.PI);
    public static final LispDouble INEXACT_RAD_PER_DEG = new LispDouble(Math.PI / 180);

    private LispMath() {
    }

    private static LispNumber exptC(LispNumber nm1, LispNumber nm2) {
        double a1 = nm1.getRealDouble();
        double b1 = nm1.getImagDouble();
        double r1 = Math.hypot(a1, b1);
        double t1 = Math.atan2(b1, a1);
        double a2 = nm2.getRealDouble();
        double b2 = nm2.getImagDouble();
        double rr = a2 * Math.log(r1) - t1 * b2;
        double tr = b2 * Math.log(r1) + t1 * a2;
        return LispComplex.newComplex(Math.exp(rr) * Math.cos(tr), Math.exp(rr) * Math.sin(tr));
    }

    public static boolean isPlusZero(double r) {
        return r == 0.0 && P_ZERO.equals(new Double(r));
    }

    public static boolean isMinusZero(double r) {
        return r == 0.0 && M_ZERO.equals(new Double(r));
    }

    public static LispNumber expt(LispNumber nm1, LispNumber nm2) {
        if (nm1.isNaN() || nm2.isNaN()) {
            return LispDouble.NaN;
        }
        if (nm2.isZero()) {
            if (nm1.isExact() && nm2.isExact()) {
                return LispInteger.ONE;
            }
            return LispDouble.ONE;
        }
        if (nm1.isZero()) {
            if (nm1.isExact() && nm2.isExact()) {
                return LispInteger.ZERO;
            }
            return LispDouble.ZERO;
        }
        if (nm1.isOne()) {
            if (nm1.isExact() && nm2.isExact()) {
                return LispInteger.ONE;
            }
            return LispDouble.ONE;
        }
        if (nm2.isOne()) {
            if (nm1.isExact() && nm2.isExact()) {
                return nm1;
            }
            return nm1.toInexact();
        }
        if (!nm2.isReal()) {
            return LispMath.exptC(nm1, nm2);
        }
        if (!nm1.isReal()) {
            return LispMath.expt(nm1, nm2.getRealDouble());
        }
        if (!(nm1.isExact() && nm1.isRational() && nm2.isExact() && nm2.isRational())) {
            if (nm1.getRealDouble() > 0.0) {
                return new LispDouble(Math.pow(nm1.getRealDouble(), nm2.getRealDouble()));
            }
            return LispMath.expt(nm1, nm2.getRealDouble());
        }
        if (!nm2.isInteger()) {
            BigInteger rd;
            BigInteger d2;
            BigInteger n2;
            BigInteger d1;
            BigInteger n1;
            if (((LispReal)nm1).signum() < 0) {
                return LispMath.expt(nm1, nm2.getRealDouble());
            }
            if (((LispReal)nm2).signum() < 0) {
                n1 = nm1.getDenominator();
                d1 = nm1.getNumerator();
                n2 = ((LispReal)nm2).negate().getNumerator();
                d2 = ((LispReal)nm2).negate().getDenominator();
            } else {
                n1 = nm1.getNumerator();
                d1 = nm1.getDenominator();
                n2 = nm2.getNumerator();
                d2 = nm2.getDenominator();
            }
            if (d2.compareTo(LIMIT_NRT) > 0 || n2.compareTo(LIMIT_INT) > 0) {
                return new LispDouble(Math.pow(nm1.getRealDouble(), nm2.getRealDouble()));
            }
            BigInteger rn = Math2.nrtExact(n1, d2);
            if (rn.signum() < 0 || (rd = Math2.nrtExact(d1, d2)).signum() < 0) {
                return new LispDouble(Math.pow(nm1.getRealDouble(), nm2.getRealDouble()));
            }
            return LispRational.newRational(rn.pow(n2.intValue()), rd.pow(n2.intValue()));
        }
        if (nm1.isInteger()) {
            LispReal rm2 = nm2.getReal();
            BigInteger b = rm2.getBigInteger();
            Integer b2 = IntLispUtils.toIntExact(b);
            BigInteger a = nm1.getReal().getBigInteger();
            if (b2 == null) {
                return new LispDouble(Math.pow(nm1.getRealDouble(), nm2.getRealDouble()));
            }
            if (b.signum() > 0) {
                return LispInteger.valueOf(a.pow(b2));
            }
            return LispRational.newRational(BigInteger.ONE, a.pow(-b2.intValue()));
        }
        if (nm1.isRational()) {
            LispReal rm2 = nm2.getReal();
            BigInteger b = rm2.getBigInteger();
            Integer b2 = IntLispUtils.toIntExact(b);
            BigInteger an = nm1.getReal().getNumerator();
            BigInteger ad = nm1.getReal().getDenominator();
            if (b2 == null) {
                return new LispDouble(Math.pow(nm1.getRealDouble(), nm2.getRealDouble()));
            }
            if (b.signum() > 0) {
                return LispRational.newRational(an.pow(b2), ad.pow(b2));
            }
            return LispRational.newRational(ad.pow(-b2.intValue()), an.pow(-b2.intValue()));
        }
        return LispMath.exptC(nm1, nm2);
    }

    public static LispNumber expt(LispNumber nm1, double r) {
        double a1 = nm1.getRealDouble();
        double b1 = nm1.getImagDouble();
        if (nm1.isNaN() || Double.isNaN(r)) {
            return LispDouble.NaN;
        }
        if (b1 == 0.0 && a1 == 1.0) {
            return LispDouble.ONE;
        }
        if (r == Double.POSITIVE_INFINITY) {
            double r1 = Math.hypot(a1, b1);
            if (r1 < 1.0 && r1 > -1.0) {
                return LispDouble.ZERO;
            }
            if (b1 == 0.0 && a1 > 1.0) {
                return LispDouble.POSITIVE_INFINITY;
            }
            return LispDouble.NaN;
        }
        if (r == Double.NEGATIVE_INFINITY) {
            double r1 = Math.hypot(a1, b1);
            if (r1 > 1.0 || r1 < -1.0) {
                return LispDouble.ZERO;
            }
            if (b1 == 0.0 && a1 < 1.0 && a1 > 0.0) {
                return LispDouble.POSITIVE_INFINITY;
            }
            return LispDouble.NaN;
        }
        if (b1 == 0.0 && a1 > 0.0) {
            return new LispDouble(Math.pow(a1, r));
        }
        double r1 = Math.hypot(a1, b1);
        double t1 = Math.atan2(b1, a1);
        double a2 = r;
        double rr = a2 * Math.log(r1);
        double tr = t1 * a2;
        return LispComplex.newComplex(Math.exp(rr) * Math.cos(tr), Math.exp(rr) * Math.sin(tr));
    }

    public static LispNumber sqrt(LispNumber n) {
        BigInteger b;
        if (n.isExact() && n.isInteger() && ((LispReal)n).signum() > 0 && (b = Math2.sqrtExact(n.getBigInteger())).signum() > 0) {
            return LispInteger.valueOf(b);
        }
        if (n.isReal()) {
            if (n.getRealDouble() == 0.0) {
                return new LispDouble(0.0);
            }
            if (n.getRealDouble() > 0.0) {
                return new LispDouble(Math.sqrt(n.getRealDouble()));
            }
            return LispComplex.newComplex(0.0, Math.sqrt(-n.getRealDouble()));
        }
        return LispMath.expt(n, 0.5);
    }

    public static LispNumber exp(LispNumber n) {
        if (n.isReal()) {
            return new LispDouble(Math.exp(n.getRealDouble()));
        }
        double a = n.getRealDouble();
        double b = n.getImagDouble();
        return LispComplex.newComplex(Math.exp(a) * Math.cos(b), Math.exp(a) * Math.sin(b));
    }

    public static LispNumber log(LispNumber n) {
        if (n.getReal().isZero() && LispMath.isMinusZero(n.getImagDouble())) {
            return N_INF_PI_HALF_I;
        }
        if (n.isReal() && n.getReal().signum() > 0) {
            return new LispDouble(Math.log(n.getRealDouble()));
        }
        double a = n.getRealDouble();
        double b = n.getImagDouble();
        double r = Math.hypot(a, b);
        double t = Math.atan2(b, a);
        return LispComplex.newComplex(Math.log(r), t);
    }

    public static LispNumber sin(LispNumber n) {
        if (n.isReal()) {
            return new LispDouble(Math.sin(n.getRealDouble()));
        }
        if (n.getReal().isZero()) {
            double y = n.getImagDouble();
            double b = Math.sinh(y);
            return LispComplex.newComplex(0.0, b);
        }
        double x = n.getRealDouble();
        double y = n.getImagDouble();
        double a = Math.sin(x) * Math.cosh(y);
        double b = Math.cos(x) * Math.sinh(y);
        return LispComplex.newComplex(a, b);
    }

    public static LispNumber cos(LispNumber n) {
        if (n.isReal()) {
            return new LispDouble(Math.cos(n.getRealDouble()));
        }
        if (n.getReal().isZero()) {
            double y = n.getImagDouble();
            double a = Math.cosh(y);
            return LispComplex.newComplex(a, 0.0);
        }
        double x = n.getRealDouble();
        double y = n.getImagDouble();
        double a = Math.cos(x) * Math.cosh(y);
        double b = -(Math.sin(x) * Math.sinh(y));
        return LispComplex.newComplex(a, b);
    }

    public static LispNumber tan(LispNumber n) {
        if (n.isReal()) {
            return new LispDouble(Math.tan(n.getRealDouble()));
        }
        if (n.getReal().isZero()) {
            double y = n.getImagDouble();
            return LispComplex.newComplex(0.0, Math.tanh(y));
        }
        if (n.getImagDouble() == Double.POSITIVE_INFINITY) {
            double x = n.getRealDouble();
            LispNumber nm = LispComplex.newComplex(Math.tan(x), 1.0);
            LispNumber dn = LispComplex.newComplex(1.0, Math.tan(x));
            return nm.div(dn);
        }
        if (n.getImagDouble() == Double.NEGATIVE_INFINITY) {
            double x = n.getRealDouble();
            LispNumber nm = LispComplex.newComplex(Math.tan(x), -1.0);
            LispNumber dn = LispComplex.newComplex(1.0, -Math.tan(x));
            return nm.div(dn);
        }
        return LispMath.sin(n).div(LispMath.cos(n));
    }

    public static LispNumber sinDeg(LispNumber n) {
        if (n.isExact() && n.isInteger()) {
            int s;
            int b = n.getBigInteger().remainder(DEG_ALL).intValue();
            switch (b / 90) {
                case 0: {
                    s = 1;
                    break;
                }
                case 1: {
                    s = 1;
                    b = 180 - b;
                    break;
                }
                case 2: {
                    s = -1;
                    b -= 180;
                    break;
                }
                case 3: {
                    s = -1;
                    b = 360 - b;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            switch (b) {
                case 0: {
                    return LispInteger.ZERO;
                }
                case 30: {
                    return LispRational.newRational(s, 2);
                }
                case 45: {
                    break;
                }
                case 60: {
                    break;
                }
                case 90: {
                    return LispInteger.valueOf(s);
                }
            }
        }
        return LispMath.sin(n.mul(INEXACT_RAD_PER_DEG));
    }

    public static LispNumber cosDeg(LispNumber n) {
        if (n.isExact() && n.isInteger()) {
            int s;
            int b = n.getBigInteger().remainder(DEG_ALL).intValue();
            switch (b / 90) {
                case 0: {
                    s = 1;
                    break;
                }
                case 1: {
                    s = -1;
                    b = 180 - b;
                    break;
                }
                case 2: {
                    s = -1;
                    b -= 180;
                    break;
                }
                case 3: {
                    s = 1;
                    b = 360 - b;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            switch (b) {
                case 0: {
                    return LispInteger.valueOf(s);
                }
                case 30: {
                    break;
                }
                case 45: {
                    break;
                }
                case 60: {
                    return LispRational.newRational(s, 2);
                }
                case 90: {
                    return LispInteger.ZERO;
                }
            }
        }
        return LispMath.cos(n.mul(INEXACT_RAD_PER_DEG));
    }

    public static LispNumber tanDeg(LispNumber n) {
        if (n.isExact() && n.isInteger()) {
            int s;
            int b = n.getBigInteger().remainder(DEG_ALL).intValue();
            switch (b / 90) {
                case 0: {
                    s = 1;
                    break;
                }
                case 1: {
                    s = -1;
                    b = 180 - b;
                    break;
                }
                case 2: {
                    s = -1;
                    b -= 180;
                    break;
                }
                case 3: {
                    s = 1;
                    b = 360 - b;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            switch (b) {
                case 0: {
                    return LispInteger.ZERO;
                }
                case 30: {
                    break;
                }
                case 45: {
                    return LispInteger.valueOf(s);
                }
                case 60: {
                    break;
                }
            }
        }
        return LispMath.tan(n.mul(INEXACT_RAD_PER_DEG));
    }

    public static LispNumber asin(LispNumber n) {
        double x = n.getRealDouble();
        double y = n.getImagDouble();
        if (n.isReal() && x >= -1.0 && x <= 1.0) {
            return new LispDouble(Math.asin(n.getRealDouble()));
        }
        if (Double.isInfinite(x) && Double.isInfinite(y)) {
            return LispDouble.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            if (y <= 0.0) {
                x = -x;
            }
            return LispComplex.newComplex(1.5707963267948966, x);
        }
        if (x == Double.NEGATIVE_INFINITY) {
            if (y >= 0.0) {
                x = -x;
            }
            return LispComplex.newComplex(-1.5707963267948966, x);
        }
        if (y == Double.POSITIVE_INFINITY) {
            return LispComplex.newComplex(0.0, y);
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return LispComplex.newComplex(0.0, y);
        }
        LispNumber z1 = LispComplex.I.mul(n);
        LispNumber z2 = LispMath.sqrt(LispDouble.ONE.sub(n.mul(n)));
        LispNumber z3 = LispMath.log(z1.add(z2));
        return LispComplex.newComplex(z3.getImagDouble(), -z3.getRealDouble());
    }

    public static LispNumber acos(LispNumber n) {
        double x = n.getRealDouble();
        if (n.isReal() && x >= -1.0 && x <= 1.0) {
            return new LispDouble(Math.acos(n.getRealDouble()));
        }
        LispDouble pi2 = new LispDouble(1.5707963267948966);
        return ((LispNumber)pi2).sub(LispMath.asin(n));
    }

    public static LispNumber atan(LispNumber n) {
        if (n.isReal()) {
            return new LispDouble(Math.atan(n.getRealDouble()));
        }
        if (Double.isInfinite(n.getImagDouble())) {
            double im = n.getImagDouble();
            if (Double.isInfinite(n.getRealDouble())) {
                return LispDouble.NaN;
            }
            if (im > 0.0) {
                return new LispDouble(1.5707963267948966);
            }
            return new LispDouble(-1.5707963267948966);
        }
        LispNumber z1 = LispDouble.ONE.add(LispComplex.I.mul(n));
        LispNumber z2 = LispDouble.ONE.sub(LispComplex.I.mul(n));
        LispNumber z3 = LispMath.log(z1).sub(LispMath.log(z2));
        return z3.div(TWO_I);
    }

    public static LispNumber asinDeg(LispNumber n) {
        if (n.isExact() && n.isInteger()) {
            Integer x = SubrUtils.toIntExact(n.getBigInteger());
            if (x != null) {
                if (x == 0) {
                    return LispInteger.ZERO;
                }
                if (x == 1) {
                    return LispInteger.valueOf(90);
                }
                if (x == -1) {
                    return LispInteger.valueOf(-90);
                }
            }
        } else if (n.isExact() && n.isRational()) {
            Integer x = SubrUtils.toIntExact(n.getNumerator());
            Integer d = SubrUtils.toIntExact(n.getDenominator());
            if (x != null && d != null) {
                if (x == 1 && d == 2) {
                    return LispInteger.valueOf(30);
                }
                if (x == -1 && d == 2) {
                    return LispInteger.valueOf(-30);
                }
            }
        }
        return LispMath.asin(n.div(INEXACT_RAD_PER_DEG));
    }

    public static LispNumber acosDeg(LispNumber n) {
        if (n.isExact() && n.isInteger()) {
            Integer x = SubrUtils.toIntExact(n.getBigInteger());
            if (x != null) {
                if (x == 0) {
                    return LispInteger.valueOf(90);
                }
                if (x == 1) {
                    return LispInteger.ZERO;
                }
                if (x == -1) {
                    return LispInteger.valueOf(180);
                }
            }
        } else if (n.isExact() && n.isRational()) {
            Integer x = SubrUtils.toIntExact(n.getNumerator());
            Integer d = SubrUtils.toIntExact(n.getDenominator());
            if (x != null && d != null) {
                if (x == 1 && d == 2) {
                    return LispInteger.valueOf(60);
                }
                if (x == -1 && d == 2) {
                    return LispInteger.valueOf(120);
                }
            }
        }
        return LispMath.acos(n.div(INEXACT_RAD_PER_DEG));
    }

    public static LispNumber atanDeg(LispNumber n) {
        Integer x;
        if (n.isExact() && n.isInteger() && (x = SubrUtils.toIntExact(n.getBigInteger())) != null) {
            if (x == 0) {
                return LispInteger.ZERO;
            }
            if (x == 1) {
                return LispInteger.valueOf(45);
            }
            if (x == -1) {
                return LispInteger.valueOf(-45);
            }
        }
        return LispMath.atan(n.div(INEXACT_RAD_PER_DEG));
    }

    public static LispReal realLog(LispReal x, LispReal y) {
        if (x.signum() < 0 || y.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        if (x.signum() == 0) {
            return LispDouble.NEGATIVE_INFINITY;
        }
        if (x.isExact() && x.isInteger() && y.isExact() && y.isInteger()) {
            return LispInteger.valueOf(Math2.integerLog(x.getBigInteger(), y.getBigInteger()));
        }
        return new LispDouble(Math.log(x.doubleValue()) / y.doubleValue());
    }

    public static LispReal quo(LispReal x, LispReal y) {
        if (x.isExact() && x.isRational() && y.isExact() && y.isRational()) {
            LispReal z = x.divide(y);
            return LispInteger.valueOf(z.getNumerator().divide(z.getDenominator()));
        }
        BigDecimal z = BigDecimal.valueOf(x.getRealDouble() / y.getRealDouble());
        return new LispDouble(z.toBigInteger().doubleValue());
    }

    public static LispReal rem(LispReal x, LispReal y) {
        double x2;
        if (x.isExact() && x.isRational() && y.isExact() && y.isRational()) {
            LispReal z = x.divide(y);
            BigInteger n = z.getNumerator().divide(z.getDenominator());
            LispReal w = x.subtract(y.multiply(LispInteger.valueOf(n)));
            return w;
        }
        double x1 = x.getRealDouble();
        double x3 = x1 / (x2 = y.getRealDouble());
        x3 = x3 > 0.0 ? Math.floor(x3) : Math.ceil(x3);
        return new LispDouble(x1 - x2 * x3);
    }

    public static LispReal mod(LispReal x, LispReal y) {
        if (x.isExact() && x.isRational() && y.isExact() && y.isRational()) {
            LispReal z = x.divide(y);
            BigInteger n = z.getNumerator().divide(z.getDenominator());
            if (n.signum() < 0) {
                n = n.subtract(BigInteger.ONE);
            }
            LispReal w = x.subtract(y.multiply(LispInteger.valueOf(n)));
            return w;
        }
        double x1 = x.getRealDouble();
        double x2 = y.getRealDouble();
        return new LispDouble(x1 - x2 * Math.floor(x1 / x2));
    }
}

