/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import net.morilib.lang.algebra.Multipliable;
import net.morilib.lang.algebra.Subtractable;
import net.morilib.util.BitUtils;
import net.morilib.util.IntMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Q32FractionalPart
implements Subtractable<Q32FractionalPart>,
Multipliable<Q32FractionalPart> {
    public static Q32FractionalPart ZERO = new Q32FractionalPart(0);
    private int q32;

    private Q32FractionalPart(int numer, int denom) {
        this.q32 = 0;
        if (numer != 0) {
            int n = numer;
            int d = BitUtils.getMsb(denom);
            int i = 0;
            while (i < d) {
                if ((n & 1 << d - i - 1) != 0) {
                    this.q32 |= 1 << 31 - i;
                }
                ++i;
            }
        }
    }

    private Q32FractionalPart(int q32) {
        this.q32 = q32;
    }

    public static Q32FractionalPart valueOf(int numer, int denom) {
        int n2 = numer % denom;
        if (denom == 0) {
            throw new ArithmeticException("divide by zero");
        }
        if (numer == 0) {
            return ZERO;
        }
        if (BitUtils.countBit(denom) > 1) {
            throw new IllegalArgumentException("not 2^n");
        }
        int dd = IntMath.gcd(numer, denom);
        return new Q32FractionalPart(n2 / dd, denom / dd);
    }

    @Override
    public Q32FractionalPart add(Q32FractionalPart x) {
        return new Q32FractionalPart(this.q32 + x.q32);
    }

    @Override
    public Q32FractionalPart multiply(int n) {
        return new Q32FractionalPart(this.q32 * n);
    }

    @Override
    public Q32FractionalPart multiply(Q32FractionalPart x) {
        return new Q32FractionalPart((this.q32 >> 16) * (x.q32 >> 16));
    }

    @Override
    public Q32FractionalPart power(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return this;
        }
        Q32FractionalPart q = this;
        int i = 1;
        while (i < n) {
            q.multiply(this);
            ++i;
        }
        return q;
    }

    @Override
    public Q32FractionalPart subtract(Q32FractionalPart x) {
        return new Q32FractionalPart(this.q32 - x.q32);
    }

    public double doubleValue() {
        double res = 0.0;
        double p = 0.5;
        if (this.q32 == 0) {
            return 0.0;
        }
        int lsb = BitUtils.getLsb(this.q32) - 1;
        int i = 31;
        while (i >= lsb) {
            if ((this.q32 & 1 << i) != 0) {
                res += p;
            }
            p *= 0.5;
            --i;
        }
        return res;
    }

    public long getDenominator() {
        if (this.q32 == 0) {
            return 1L;
        }
        return 1 << 33 - BitUtils.getLsb(this.q32);
    }

    public long getNumerator() {
        if (this.q32 == 0) {
            return 0L;
        }
        int lsb = BitUtils.getLsb(this.q32) - 1;
        long res = this.q32;
        if (res < 0L) {
            res = -res & 0x80000000L;
        }
        return res >> lsb;
    }

    public boolean isZero() {
        return this.q32 == 0;
    }

    public Q32FractionalPart addHalf() {
        return new Q32FractionalPart(-this.q32);
    }
}

