/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.dfa;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.morilib.automata.TextBound;
import net.morilib.automata.dfa.DFA;
import net.morilib.automata.dfa.DFAState;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.nfa.NFA;
import net.morilib.automata.nfa.NFAState;
import net.morilib.automata.nfa.NFAs;
import net.morilib.range.Interval;
import net.morilib.util.ArrayListStack;
import net.morilib.util.TreeSectionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphDFA<T, O, B>
implements DFA<T, O, B> {
    private Map<Object, TreeSectionMap<Interval, Object, State>> graph = new IdentityHashMap<Object, TreeSectionMap<Interval, Object, State>>();
    private Map<Object, EnumMap<TextBound, State>> boundgraph = new IdentityHashMap<Object, EnumMap<TextBound, State>>();
    private Map<Object, Set<O>> accept = new IdentityHashMap<Object, Set<O>>();
    private Map<Object, Set<B>> tags = new IdentityHashMap<Object, Set<B>>();
    private State initial;

    private void addTrans(Object st, Interval i, Object nst) {
        State n = new State(nst);
        TreeSectionMap<Interval, Object, State> edges = this.graph.get(st);
        if (edges == null) {
            edges = new TreeSectionMap(i, n);
            this.graph.put(st, edges);
        } else {
            edges.insert(i, n);
        }
    }

    private void addTransBound(Object st, TextBound b, Object nst) {
        State n = new State(nst);
        EnumMap<TextBound, State> edges = this.boundgraph.get(st);
        if (edges == null) {
            edges = new EnumMap(TextBound.class);
            this.boundgraph.put(st, edges);
        }
        edges.put(b, n);
    }

    private void setInitialState(Object o) {
        this.initial = new State(o);
    }

    @Override
    public DFAState<T, O, B> getInitialState() {
        return this.initial;
    }

    public static <T, A, B> DFA<T, A, B> convertDFA(NFA<T, A, B> nfa) {
        HashMap<Set<NFAState>, Set<NFAState>> dstates = new HashMap<Set<NFAState>, Set<NFAState>>();
        ArrayListStack<Set<NFAState>> stk = new ArrayListStack<Set<NFAState>>();
        GraphDFA res = new GraphDFA();
        Set<NFAState> init = NFAs.getEpsilonReachable(nfa, nfa.getInitialStates());
        super.setInitialState(init);
        stk.push(init);
        while (!stk.isEmpty()) {
            Set t = (Set)stk.pop();
            dstates.put(t, t);
            res.tags.put(t, NFAs.getMatchTag(nfa, t));
            res.accept.put(t, NFAs.getAccept(nfa, t));
            for (Interval r : nfa.nextAlphabets(t)) {
                Set<NFAState> u = NFAs.getEpsilonReachable(nfa, NFAs.getStates(nfa, (Set<NFAState>)t, r));
                Set<NFAState> z = (Set<NFAState>)dstates.get(u);
                if (z == null) {
                    dstates.put(u, u);
                    stk.push(u);
                    z = u;
                }
                super.addTrans(t, r, z);
            }
            for (TextBound b : TextBound.ALL) {
                EnumSet<TextBound> bs = EnumSet.of(b);
                Set<NFAState> u = NFAs.getEpsilonReachable(nfa, NFAs.getStatesBound(nfa, t, bs));
                if (u.isEmpty()) continue;
                Set<NFAState> z = (Set<NFAState>)dstates.get(u);
                if (z == null) {
                    dstates.put(u, u);
                    stk.push(u);
                    z = u;
                }
                super.addTransBound(t, b, z);
            }
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class State
    implements DFAState<T, O, B> {
        private Object st;

        private State(Object st) {
            this.st = st;
        }

        @Override
        public DFAState<T, O, B> go(T alphabet) {
            TreeSectionMap ts = (TreeSectionMap)GraphDFA.this.graph.get(this.st);
            if (ts == null) {
                return DFAs.deadState();
            }
            State s2 = (State)ts.map(alphabet);
            if (s2 == null) {
                return DFAs.deadState();
            }
            return s2;
        }

        @Override
        public DFAState<T, O, B> goBound(TextBound bound) {
            EnumMap ts = (EnumMap)GraphDFA.this.boundgraph.get(this.st);
            if (ts == null) {
                return DFAs.deadState();
            }
            State s2 = (State)ts.get((Object)bound);
            if (s2 == null) {
                return DFAs.deadState();
            }
            return s2;
        }

        @Override
        public Set<O> getAccepted() {
            Set res = (Set)GraphDFA.this.accept.get(this.st);
            return res == null ? Collections.emptySet() : res;
        }

        @Override
        public boolean isInitialState() {
            return GraphDFA.this.initial == this.st;
        }

        @Override
        public boolean isDead() {
            return false;
        }
    }
}

