/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import net.morilib.lang.number.Numbers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRangeSet
extends AbstractSet<Integer>
implements SortedSet<Integer>,
Serializable {
    private static final long serialVersionUID = -6403675898652617915L;
    private static final Comparator<? super Integer> _CMP = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1 > o2 ? 1 : (o1 < o2 ? -1 : 0);
        }
    };
    private int from;
    private int to;

    public IntegerRangeSet(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean add(Integer o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Number) {
            return Numbers.between((Number)o, this.from, this.to);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new _Itr();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.to - this.from + 1;
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return _CMP;
    }

    @Override
    public Integer first() {
        return this.from;
    }

    @Override
    public SortedSet<Integer> headSet(Integer toElement) {
        if (toElement < this.from || toElement > this.to) {
            throw new IllegalArgumentException();
        }
        return new IntegerRangeSet(this.from, toElement);
    }

    @Override
    public Integer last() {
        return this.to;
    }

    @Override
    public SortedSet<Integer> subSet(Integer fromElement, Integer toElement) {
        if (toElement < this.from || toElement > this.to) {
            throw new IllegalArgumentException();
        }
        if (fromElement < this.from || fromElement > this.to) {
            throw new IllegalArgumentException();
        }
        if (toElement < fromElement) {
            throw new IllegalArgumentException();
        }
        return new IntegerRangeSet(fromElement, toElement);
    }

    @Override
    public SortedSet<Integer> tailSet(Integer fromElement) {
        if (fromElement < this.from || fromElement > this.to) {
            throw new IllegalArgumentException();
        }
        return new IntegerRangeSet(fromElement, this.to);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IntegerRangeSet) {
            IntegerRangeSet s = (IntegerRangeSet)o;
            return this.from == s.from && this.to == s.to;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 17;
        r = r * 37 + this.from;
        r = r * 37 + this.to;
        return r;
    }

    @Override
    public String toString() {
        return "Z[" + this.from + ", " + this.to + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _Itr
    implements Iterator<Integer> {
        private int now;

        private _Itr() {
            this.now = IntegerRangeSet.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.now <= IntegerRangeSet.this.to;
        }

        @Override
        public Integer next() {
            return this.now++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

