/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.functions;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.morilib.lang.algebra.Dividable;
import net.morilib.lang.algebra.FieldElement;
import net.morilib.util.Maps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factor<F extends Comparable<F>>
implements Dividable<Factor<F>>,
Comparable<Factor<F>>,
Serializable {
    private static final long serialVersionUID = -4309016154545851641L;
    private static final Maps.Transform2<Integer> ADD_INT2 = new Maps.Transform2<Integer>(){

        @Override
        public Integer transform(Integer x, Integer y) {
            if (x == null) {
                return y == null ? null : y;
            }
            return y == null ? x : x + y;
        }
    };
    private static final Maps.Transform2<Integer> SUB_INT2 = new Maps.Transform2<Integer>(){

        @Override
        public Integer transform(Integer x, Integer y) {
            if (x == null) {
                return y == null ? null : Integer.valueOf(-y.intValue());
            }
            return y == null ? x : x - y;
        }
    };
    protected Map<F, Integer> orders = new TreeMap<F, Integer>();

    public Factor() {
    }

    public Factor(F variable) {
        this.orders.put(variable, 1);
    }

    public Factor(Factor<F> factor) {
        this.orders = new TreeMap<F, Integer>(factor.orders);
    }

    private void del0() {
        Iterator<Map.Entry<F, Integer>> i1 = this.orders.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry<F, Integer> e1 = i1.next();
            if (e1.getValue() != 0) continue;
            i1.remove();
        }
    }

    @Override
    public Factor<F> divide(Factor<F> x) {
        Factor<F> res = new Factor<F>();
        res.orders = Maps.map(SUB_INT2, new TreeMap(), this.orders, x.orders);
        this.del0();
        return res;
    }

    @Override
    public Factor<F> multiply(Factor<F> x) {
        Factor<F> res = new Factor<F>();
        res.orders = Maps.map(ADD_INT2, new TreeMap(), this.orders, x.orders);
        this.del0();
        return res;
    }

    @Override
    public Factor<F> power(int n) {
        Factor<F> res = new Factor<F>();
        final int y = n;
        res.orders = Maps.map(new Maps.Transform<Integer>(){

            @Override
            public Integer transform(Integer x) {
                return x * y;
            }
        }, new TreeMap(), this.orders);
        return res;
    }

    @Override
    public int compareTo(Factor<F> o) {
        Iterator<Map.Entry<F, Integer>> i1 = this.orders.entrySet().iterator();
        Iterator<Map.Entry<F, Integer>> i2 = o.orders.entrySet().iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Map.Entry<F, Integer> e1 = i1.next();
            Map.Entry<F, Integer> e2 = i2.next();
            int cr = ((Comparable)e1.getKey()).compareTo((Comparable)e2.getKey());
            if (cr != 0) {
                return cr;
            }
            cr = e1.getValue().compareTo(e2.getValue());
            if (cr == 0) continue;
            return cr;
        }
        return i1.hasNext() ? 1 : (i2.hasNext() ? -1 : 0);
    }

    public boolean containsVariable(F var) {
        return this.orders.containsKey(var);
    }

    public int getOrder(F var) {
        Integer res = this.orders.get(var);
        if (res == null) {
            throw new IllegalArgumentException();
        }
        return res;
    }

    public Factor<F> removeVariable(F var) {
        Factor<F> res = new Factor<F>();
        for (Map.Entry<F, Integer> m : this.orders.entrySet()) {
            if (((Comparable)m.getKey()).equals(var)) continue;
            res.orders.put((Comparable)m.getKey(), m.getValue());
        }
        return res;
    }

    public Factor<F> removeVariables(Set<F> vars) {
        Factor<F> res = new Factor<F>();
        for (Map.Entry<F, Integer> m : this.orders.entrySet()) {
            if (vars.contains(m.getKey())) continue;
            res.orders.put((Comparable)m.getKey(), m.getValue());
        }
        return res;
    }

    public boolean isConstant() {
        return this.orders.isEmpty();
    }

    public boolean isPolynomial() {
        for (Integer i : this.orders.values()) {
            if (i >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isLinear() {
        if (this.orders.size() == 1) {
            Map.Entry<F, Integer> e = this.orders.entrySet().iterator().next();
            return e.getValue() == 1;
        }
        return this.isConstant();
    }

    public <G extends Comparable<G>> Factor<G> replaceVariables(Map<F, G> map) {
        Factor<F> res = new Factor<F>();
        TreeMap<F, Integer> o2 = new TreeMap<F, Integer>();
        for (Map.Entry<F, Integer> e : this.orders.entrySet()) {
            Comparable g = (Comparable)map.get(e.getKey());
            int val = e.getValue();
            if (g == null) {
                return null;
            }
            if (o2.containsKey(g)) {
                val = (Integer)o2.get(g) + val;
            }
            o2.put(g, val);
        }
        res.orders = o2;
        return res;
    }

    public void collectVariables(Set<F> res) {
        res.addAll(this.orders.keySet());
    }

    public Factor<F> differenciate(F var) {
        Factor<F> res = new Factor<F>();
        if (this.containsVariable(var)) {
            for (Map.Entry<F, Integer> m : this.orders.entrySet()) {
                if (((Comparable)m.getKey()).equals(var)) {
                    int n = m.getValue();
                    if (n <= 0) continue;
                    res.orders.put((Comparable)m.getKey(), n - 1);
                    continue;
                }
                res.orders.put((Comparable)m.getKey(), m.getValue());
            }
        }
        return res;
    }

    public <C extends FieldElement<C>> C replaceAll(Map<F, C> values) {
        FieldElement res = null;
        if (!values.keySet().containsAll(this.orders.keySet())) {
            return null;
        }
        for (Map.Entry<F, C> m : values.entrySet()) {
            FieldElement r1 = (FieldElement)((FieldElement)m.getValue()).power(this.orders.get(m.getKey()));
            FieldElement fieldElement = res = res == null ? r1 : res.multiply(r1);
        }
        return (C)res;
    }

    public boolean isSingleVariable() {
        return this.orders.size() <= 1;
    }

    public boolean equals(Object o) {
        if (o instanceof Factor) {
            return this.orders.equals(((Factor)o).orders);
        }
        return false;
    }

    public int hashCode() {
        return this.orders.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String a = "";
        for (Map.Entry<F, Integer> m : this.orders.entrySet()) {
            String k = ((Comparable)m.getKey()).toString();
            int v = m.getValue();
            if (k.length() == 1) {
                buf.append(k);
            } else {
                buf.append(a).append(k);
            }
            if (v != 1) {
                buf.append("^").append(v);
            }
            a = "*";
        }
        return buf.toString();
    }
}

