/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.ActionListenable;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.ILispButton;
import net.morilib.lisp.swing.LispSwing;

public class LispRadioButton
extends GUIElement
implements ILispButton,
ActionListenable {
    JRadioButton radio;

    public LispRadioButton(JRadioButton radio) {
        this.radio = radio;
    }

    public Component getAWTComponent() {
        return this.radio;
    }

    public AbstractButton getComponent() {
        return this.radio;
    }

    public void addActionListener(ActionListener listener) {
        this.radio.addActionListener(listener);
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<radio-button>");
    }

    public static class MakeRadioButton
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            JRadioButton r;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 1) {
                String t = SubrUtils.getString(l.get(0), mesg);
                r = new JRadioButton(t);
            } else if (l.size() == 2) {
                String t = SubrUtils.getString(l.get(0), mesg);
                r = new JRadioButton(t);
                r.addActionListener(LispSwing.createActionListener(l.get(1), env, mesg));
            } else {
                throw mesg.getError("err.argument", body);
            }
            return new LispRadioButton(r);
        }
    }
}

