/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.util.List;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.LispSpinner;

public class LispNumberSpinner
extends LispSpinner {
    private LispNumberSpinner(JSpinner spinner) {
        super(spinner);
    }

    private static boolean issmallintorfalse(Datum d) {
        return d instanceof LispSmallInt || !d.isTrue();
    }

    private static Comparable smallintorfalse(Datum d) {
        return d.isTrue() ? Integer.valueOf(d.getInt()) : null;
    }

    private static Comparable floatorfalse(Datum d) {
        return d.isTrue() ? Float.valueOf(((LispSmallInt)d).floatValue()) : null;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<number-spinner>");
    }

    /* synthetic */ LispNumberSpinner(JSpinner jSpinner, LispNumberSpinner lispNumberSpinner) {
        this(jSpinner);
    }

    public static class MakeNumberSpinner
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            String fmt = null;
            if (l.size() < 4 || l.size() > 5) {
                throw mesg.getError("err.argument");
            }
            if (!(l.get(0) instanceof LispReal)) {
                throw mesg.getError("err.require.real", l.get(0));
            }
            if (!(l.get(1) instanceof LispReal)) {
                throw mesg.getError("err.require.real", l.get(1));
            }
            if (!(l.get(2) instanceof LispReal)) {
                throw mesg.getError("err.require.real", l.get(2));
            }
            if (!(l.get(3) instanceof LispReal)) {
                throw mesg.getError("err.require.real", l.get(3));
            }
            if (l.size() != 4) {
                fmt = SubrUtils.getString(l.get(4), mesg);
            }
            SpinnerNumberModel model = l.get(0) instanceof LispSmallInt && LispNumberSpinner.issmallintorfalse(l.get(1)) && LispNumberSpinner.issmallintorfalse(l.get(2)) && l.get(3) instanceof LispSmallInt ? new SpinnerNumberModel((Number)l.get(0).getInt(), LispNumberSpinner.smallintorfalse(l.get(1)), LispNumberSpinner.smallintorfalse(l.get(2)), (Number)l.get(3).getInt()) : new SpinnerNumberModel((Number)l.get(0).getRealDouble(), LispNumberSpinner.floatorfalse(l.get(1)), LispNumberSpinner.floatorfalse(l.get(2)), (Number)l.get(3).getRealDouble());
            JSpinner spinner = new JSpinner(model);
            JSpinner.NumberEditor editor = fmt == null ? new JSpinner.NumberEditor(spinner) : new JSpinner.NumberEditor(spinner, fmt);
            spinner.setEditor(editor);
            return new LispNumberSpinner(spinner, null);
        }
    }
}

