/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.ILispButton;
import net.morilib.util.Pair;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

public class LispButtonGroup
extends Datum2 {
    private ButtonGroup group;
    private OneToOneSet<AbstractButton, Datum> map = new HashOneToOneSet<AbstractButton, Datum>();

    private LispButtonGroup() {
        this.group = new ButtonGroup();
    }

    private void put(AbstractButton button, Datum d) {
        this.group.add(button);
        this.map.put(button, d);
    }

    public Datum getSelected() {
        for (Pair pair : this.map) {
            if (!((AbstractButton)pair.getA()).isSelected()) continue;
            return (Datum)pair.getB();
        }
        return LispBoolean.FALSE;
    }

    public void setSelected(Datum d) {
        AbstractButton b = (AbstractButton)this.map.getKey(d);
        if (b != null) {
            b.setSelected(true);
        }
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<button-group>");
    }

    /* synthetic */ LispButtonGroup(LispButtonGroup lispButtonGroup) {
        this();
    }

    public static class GetSelectedButtonValue
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispButtonGroup) {
                return ((LispButtonGroup)c1a).getSelected();
            }
            throw mesg.getError("err.swing.require.buttongroup", c1a);
        }
    }

    public static class MakeButtonGroup
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            LispButtonGroup g = new LispButtonGroup(null);
            ConsIterator itr = new ConsIterator(c1a);
            while (itr.hasNext()) {
                Datum d = itr.next();
                if (d instanceof Cons) {
                    Cons c = (Cons)d;
                    if (c.getCar() instanceof ILispButton) {
                        g.put(((ILispButton)((Object)c.getCar())).getComponent(), c.getCdr());
                        continue;
                    }
                    throw mesg.getError("err.swing.require.button", c.getCar());
                }
                throw mesg.getError("err.require.pair", d);
            }
            if (!itr.getTerminal().isNil()) {
                throw mesg.getError("err.list", c1a);
            }
            return g;
        }
    }

    public static class SetSelectedButtonValueS
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispButtonGroup) {
                ((LispButtonGroup)c1a).setSelected(c2a);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.swing.require.buttongroup", c1a);
        }
    }
}

