/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;

public class MakeString
extends Subr {
    private String makeString(int len, char ch) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < len) {
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() == 1) {
            int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
            if (t < 0) {
                throw mesg.getError("err.require.int.nonnegative", lst.get(0));
            }
            return new LispString(this.makeString(t, ' '));
        }
        if (lst.size() == 2) {
            int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
            char ch = SubrUtils.getCharacter(lst.get(1), mesg);
            if (t < 0) {
                throw mesg.getError("err.require.int.nonnegative", lst.get(0));
            }
            return new LispString(this.makeString(t, ch));
        }
        throw mesg.getError("err.argument", this.symbolName);
    }
}

