/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.geometry.g2d;

import net.morilib.geometry.g2d.Vector2D;
import net.morilib.geometry.g2d.VectorFactory2D;
import net.morilib.lisp.Atom;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispVector2D
extends Atom
implements Vector2D<LispVector2D, LispReal> {
    private static final VectorFactory2D<LispVector2D, LispReal> _FIELDR = new VectorFactory2D<LispVector2D, LispReal>(){

        @Override
        public LispVector2D create(LispReal x, LispReal y) {
            return new LispVector2D(x, y);
        }
    };
    private LispReal vx;
    private LispReal vy;

    public LispVector2D(LispReal x, LispReal y) {
        if (x == null || y == null) {
            throw new NullPointerException();
        }
        this.vx = x;
        this.vy = y;
    }

    public LispVector2D(double x, double y) {
        this(new LispDouble(x), new LispDouble(y));
    }

    public LispVector2D(long x, long y) {
        this(LispInteger.valueOf(x), LispInteger.valueOf(y));
    }

    @Override
    public LispVector2D multiply(LispReal a) {
        return new LispVector2D(this.vx.multiply(a), this.vy.multiply(a));
    }

    @Override
    public LispVector2D negate() {
        return new LispVector2D(this.vx.negate(), this.vy.negate());
    }

    @Override
    public LispVector2D subtract(LispVector2D x) {
        return new LispVector2D(this.vx.subtract(x.vx), this.vy.subtract(x.vy));
    }

    @Override
    public LispVector2D add(LispVector2D x) {
        return new LispVector2D(this.vx.add(x.vx), this.vy.add(x.vy));
    }

    @Override
    public LispVector2D multiply(int n) {
        return new LispVector2D((LispReal)this.vx.multiply(n), (LispReal)this.vy.multiply(n));
    }

    @Override
    public LispReal getX() {
        return this.vx;
    }

    @Override
    public LispReal getY() {
        return this.vy;
    }

    @Override
    public LispReal innerProduct(LispVector2D p) {
        return this.vx.multiply(p.vx).add(this.vy.multiply(p.vy));
    }

    @Override
    public LispReal crossProduct(LispVector2D p) {
        return this.vx.multiply(p.vy).subtract(this.vy.multiply(p.vx));
    }

    @Override
    public VectorFactory2D<LispVector2D, LispReal> getFactory() {
        return _FIELDR;
    }

    @Override
    public String print() {
        return this.toString();
    }

    @Override
    public String getResult() {
        return "(make-vector2d " + this.vx.getResult() + " " + this.vy.getResult() + ")";
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.print());
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("(").append(this.vx.getResult());
        buf.append(", ").append(this.vy.getResult()).append(")");
    }

    public int hashCode() {
        int r = 17;
        r = (r + this.vx.hashCode()) * 37;
        r = (r + this.vy.hashCode()) * 37;
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispVector2D) {
            return this.vx.equals(((LispVector2D)obj).vx) && this.vy.equals(((LispVector2D)obj).vy);
        }
        return false;
    }
}

