/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class LispLineCursor
extends Datum2 {
    private BufferedReader rd;
    private String now;

    public LispLineCursor(File fn, String enc) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        if (fn == null) {
            throw new NullPointerException();
        }
        this.rd = enc == null ? new BufferedReader(new FileReader(fn)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fn), enc));
        this.next();
    }

    public Datum getLine() {
        return new LispString(this.now);
    }

    public boolean hasLine() {
        return this.now != null;
    }

    public void next() throws IOException {
        while ((this.now = this.rd.readLine()) != null) {
            if (!this.test(this.now)) continue;
            return;
        }
    }

    protected boolean test(String now2) {
        return true;
    }

    public void close() throws IOException {
        this.rd.close();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<line-cursor>");
    }

    public static class CloseLineCursor
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispLineCursor) {
                try {
                    ((LispLineCursor)c1a).close();
                    return Undef.UNDEF;
                }
                catch (IOException e) {
                    throw mesg.getError("err.io", e.getMessage());
                }
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }

    public static class IsLineCursorNull
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispLineCursor) {
                return LispBoolean.getInstance(!((LispLineCursor)c1a).hasLine());
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }

    public static class LineCursorCar
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispLineCursor) {
                LispLineCursor fc = (LispLineCursor)c1a;
                if (!fc.hasLine()) {
                    throw mesg.getError("err.file.nomorelines");
                }
                return fc.getLine();
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }

    public static class LineCursorCdr
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispLineCursor) {
                LispLineCursor fc = (LispLineCursor)c1a;
                if (!fc.hasLine()) {
                    throw mesg.getError("err.file.nomorelines");
                }
                try {
                    fc.next();
                    return c1a;
                }
                catch (IOException e) {
                    throw mesg.getError("err.io", e.getMessage());
                }
            }
            throw mesg.getError("err.file.require.linecursor", c1a);
        }
    }

    public static class OpenLineCursor
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            String f = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            String e = SubrUtils.nextString((Iterator<Datum>)itr, null, mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                return new LispLineCursor(LispFiles.getFile(env, f), e);
            }
            catch (UnsupportedEncodingException e1) {
                throw mesg.getError("err.unsupportedencoding", e);
            }
            catch (FileNotFoundException e1) {
                throw mesg.getError("err.filenotfound", f);
            }
            catch (IOException e1) {
                throw mesg.getError("err.io", e1.getMessage());
            }
        }
    }
}

