/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.exlib;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.exlib.CharSetPropertyHandler;
import net.morilib.lisp.exlib.CharSetPropertyParser;
import net.morilib.range.CharSets;
import net.morilib.range.Interval;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.util.MutableTuple2;

public class LispCharSet
extends Datum2 {
    private static final Map<String, LispCharSet> _RANGES;
    public static final LispCharSet UNIVERSAL;
    public static final LispCharSet GRAPHIC;
    public static final LispCharSet WHITESPACE;
    private Range charset;

    static {
        UNIVERSAL = new LispCharSet(CharSets.ALL_CHAR);
        InputStream ins = LispCharSet.class.getResourceAsStream("/net/morilib/lisp/exlib/charset2.txt");
        _RANGES = new HashMap<String, LispCharSet>();
        try {
            final MutableTuple2 mt = new MutableTuple2();
            CharSetPropertyParser.parse(ins, new CharSetPropertyHandler(){

                public void singleChar(int ch) {
                    ((RangeAdder)mt.getB()).addInterval(LispCharSet.getintv(ch, ch));
                }

                public void rangedChar(int cb, int ce) {
                    ((RangeAdder)mt.getB()).addInterval(LispCharSet.getintv(cb, ce));
                }

                public void charsetName(String name) {
                    if (mt.getA() != null) {
                        _RANGES.put((String)mt.getA(), new LispCharSet(((RangeAdder)mt.getB()).toRange()));
                    }
                    mt.setA(name);
                    mt.setB(new RangeAdder());
                }
            });
            GRAPHIC = _RANGES.get("char-set:graphic");
            WHITESPACE = _RANGES.get("char-set:whitespace");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LispCharSet(char ... cs) {
        this.charset = Range.O;
        char[] cArray = cs;
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            this.charset = this.charset.join(IntervalsInt.newRightOpenInterval(c, c + '\u0001'));
            ++n2;
        }
    }

    public LispCharSet(CharSequence cs) {
        this.charset = Range.O;
        int i = 0;
        while (i < cs.length()) {
            char c = cs.charAt(i);
            this.charset = this.charset.join(IntervalsInt.newRightOpenInterval(c, c + '\u0001'));
            ++i;
        }
    }

    public LispCharSet(Range charset) {
        this.charset = charset;
    }

    private static Interval getintv(int ch, int ch2) {
        return IntervalsInt.newRightOpenInterval(ch, ch2 + 1);
    }

    public static LispCharSet parse(CharSequence s) {
        Range r = CharSets.parse(s);
        return r != null ? new LispCharSet(r) : null;
    }

    public boolean contains(char c) {
        return this.charset.contains(c);
    }

    public LispCharSet complement() {
        return new LispCharSet(this.charset.complement(CharSets.ALL_CHAR));
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<char-set>");
    }
}

