/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArray;
import net.morilib.lisp.array.SRFI25Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispRank0Array
extends SRFI25Array {
    private Datum datum;

    LispRank0Array(Datum d) {
        this.datum = d;
    }

    @Override
    public int rank() {
        return 0;
    }

    @Override
    public int startIndex(int dim) {
        throw new IndexOutOfBoundsException("" + dim);
    }

    @Override
    public int endIndex(int dim) {
        throw new IndexOutOfBoundsException("" + dim);
    }

    @Override
    public LispVector toVector() {
        return new LispVector(this.datum);
    }

    @Override
    public Datum getFromArray(int ... is) {
        if (is.length > 0) {
            throw new InvalidDimensionException();
        }
        return this.datum;
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        if (is.length > 0) {
            throw new InvalidDimensionException();
        }
        this.datum = d;
    }

    @Override
    public boolean isIndexEqualTo(LispArray a) {
        return a.rank() == 0;
    }

    @Override
    public boolean isEqualTo(LispArray a) {
        if (a.rank() == 0) {
            return LispUtils.equals(this.datum, a.getFromArray(new int[0]));
        }
        return false;
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        if (itr.hasNext()) {
            this.datum = itr.next();
        }
    }

    @Override
    public String getTypeSpecifier() {
        return null;
    }
}

