/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import net.morilib.util.BitUtils;

public final class IEEE754Single {
    private static final int EMAX = 255;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_NORMALIZED_EXPONENT = -126;
    public static final int MIN_EXPONENT = -149;
    public static final int FRACTION_BITS = 23;

    private static float _getFloat(int sign, int exp, int frac) {
        int l = 0;
        l |= sign == 1 ? Integer.MIN_VALUE : 0;
        if (exp > -127) {
            l |= (exp + 127 & 0xFF) << 22;
        }
        return Float.intBitsToFloat(l |= frac & 0x7FFFFF);
    }

    public static int getSignumField(int x) {
        return x < 0 ? 1 : 0;
    }

    public static int getExponentField(int x) {
        return (x & 0x7F800000) >> 22;
    }

    public static int getFractionField(int x) {
        return x & 0x7FFFFF;
    }

    public static int getSignum(int x) {
        return IEEE754Single.getSignumField(x) == 0 ? 1 : -1;
    }

    public static int getExponent(int x) {
        int e = IEEE754Single.getExponentField(x);
        int f = IEEE754Single.getFractionField(x);
        if (e == 255) {
            if (f == 0) {
                return 128;
            }
            throw new ArithmeticException("Not a number");
        }
        if (e > 0) {
            return e;
        }
        return -149 + BitUtils.getMsb(f) - 1;
    }

    public boolean isNormalized(int x) {
        int e = IEEE754Single.getExponentField(x);
        return e > 0 && e < 255;
    }

    public static int getSignumField(float x) {
        return IEEE754Single.getSignumField(Float.floatToRawIntBits(x));
    }

    public static int getExponentField(float x) {
        return IEEE754Single.getExponentField(Float.floatToRawIntBits(x));
    }

    public static int getFractionField(float x) {
        return IEEE754Single.getFractionField(Float.floatToRawIntBits(x));
    }

    public static int getSignum(float x) {
        return IEEE754Single.getSignum(Float.floatToRawIntBits(x));
    }

    public static int getExponent(float x) {
        return IEEE754Single.getExponent(Float.floatToRawIntBits(x));
    }

    public boolean isNormalized(float x) {
        return this.isNormalized(Float.floatToRawIntBits(x));
    }

    public static float inclement(float x) {
        int l = Float.floatToIntBits(x);
        int s = IEEE754Single.getSignumField(l);
        int e = IEEE754Single.getExponentField(l);
        int f = IEEE754Single.getFractionField(l);
        if (x == Float.POSITIVE_INFINITY) {
            return x;
        }
        if (x == Float.NEGATIVE_INFINITY) {
            return Float.MIN_VALUE;
        }
        if (x == Float.MAX_VALUE) {
            return Float.POSITIVE_INFINITY;
        }
        if (Float.isNaN(x)) {
            return x;
        }
        if ((long)f == 0xFFFFFFFFFFFFFL) {
            return IEEE754Single._getFloat(s, e + 1, f << 1);
        }
        return IEEE754Single._getFloat(s, e, f + 1);
    }

    public static float declement(float x) {
        int l = Float.floatToIntBits(x);
        int s = IEEE754Single.getSignumField(l);
        int e = IEEE754Single.getExponentField(l);
        int f = IEEE754Single.getFractionField(l);
        if (x == Float.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        if (x == Float.NEGATIVE_INFINITY) {
            return x;
        }
        if (x == Float.MIN_VALUE) {
            return Float.NEGATIVE_INFINITY;
        }
        if (Float.isNaN(x)) {
            return x;
        }
        if ((long)f == 0L) {
            return IEEE754Single._getFloat(s, e - 1, 1);
        }
        return IEEE754Single._getFloat(s, e, f - 1);
    }
}

