/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import net.morilib.util.Arrays2;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.Endianness;

public class DoubleArray
extends AbstractUniformArray {
    private double[] array;

    private DoubleArray(double[] arr) {
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = new double[arr.length];
        System.arraycopy(arr, 0, this.array, 0, arr.length);
    }

    public DoubleArray(DoubleArray a) {
        this.array = Arrays2.copy(a.array);
    }

    public static DoubleArray newArray(double[] arr) {
        return new DoubleArray(arr);
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.getDouble(i);
    }

    @Override
    public double getDouble(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    @Override
    public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    @Override
    public int getInt(int i) {
        return (int)this.getDouble(i);
    }

    @Override
    public long getLong(int i) {
        return (long)this.getDouble(i);
    }

    @Override
    public short getShort(int i) {
        return (short)this.getDouble(i);
    }

    @Override
    public void setByte(int i, byte x) {
        this.setDouble(i, x);
    }

    @Override
    public void setDouble(int i, double x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    @Override
    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    @Override
    public void setInt(int i, int x) {
        this.setDouble(i, x);
    }

    @Override
    public void setLong(int i, long x) {
        this.setDouble(i, x);
    }

    @Override
    public void setShort(int i, short x) {
        this.setDouble(i, x);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public byte[] toByteArray(Endianness e) {
        byte[] res = new byte[this.array.length << 3];
        int i = 0;
        while (i < this.array.length) {
            e.writeLong(res, i << 3, Double.doubleToLongBits(this.array[i]));
            ++i;
        }
        return res;
    }

    public double[] toArray() {
        return Arrays2.copy(this.array);
    }
}

