/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.ByteCollections;
import net.morilib.util.primitive.ByteList;
import net.morilib.util.primitive.ByteVector;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.ByteVectorIterator;

public abstract class AbstractByteVector
extends AbstractByteCollection
implements ByteVector,
RandomAccess {
    private static final long serialVersionUID = 3332872309405682099L;
    protected transient int modCount = 0;

    @Override
    public boolean addAllByte(int index, ByteCollection a) {
        int i2 = index;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        ByteIterator i = a.byteIterator();
        while (i.hasNext()) {
            this.addByte(i2++, i.next());
        }
        return true;
    }

    @Override
    public byte first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getByte(0);
    }

    @Override
    public int indexOfByte(byte v) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getByte(i) == v) {
                    return i;
                }
                ++i;
            }
        } else {
            ByteVectorIterator i = this.byteVectorIterator();
            int j = 0;
            while (i.hasNext()) {
                if (i.next() == v) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public ByteList rest() {
        return this.subVector(1, this.size());
    }

    @Override
    public ByteList rest(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            return ByteCollections.EMPTY_VECTOR;
        }
        return this.subVector(index, this.size());
    }

    @Override
    public boolean addByte(byte v) {
        ++this.modCount;
        this.addByte(this.size(), v);
        return true;
    }

    @Override
    public boolean addAllByte(ByteCollection a) {
        return this.addAllByte(this.size(), a);
    }

    @Override
    public boolean addAllByte(ByteCollection ... as) {
        int nsize = 0;
        ByteCollection[] byteCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            ByteCollection a = byteCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            boolean r = false;
            ++this.modCount;
            ByteCollection[] byteCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                ByteCollection a = byteCollectionArray2[n];
                r = this.addAllByte(a) | r;
                ++n;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean addAllByte(Collection<? extends ByteCollection> as) {
        int nsize = 0;
        for (ByteCollection byteCollection : as) {
            nsize += byteCollection.size();
        }
        if (nsize > 0) {
            int n;
            boolean bl = false;
            ++this.modCount;
            for (ByteCollection byteCollection : as) {
                n = this.addAllByte(byteCollection) | n;
            }
            return n != 0;
        }
        return false;
    }

    @Override
    public boolean containsByte(byte v) {
        return this.indexOfByte(v) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public ByteIterator byteIterator() {
        return new Itr(null, null);
    }

    @Override
    public boolean removeByte(byte v) {
        int ind = this.indexOfByte(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean remove(Object v) {
        int ind = this.indexOf(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Byte> a) {
        ++this.modCount;
        return this.addAll(this.size(), a);
    }

    @Override
    public boolean contains(Object v) {
        return this.indexOf(v) >= 0;
    }

    @Override
    public int lastIndexOfByte(byte v) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getByte(i) == v) {
                    return i;
                }
                --i;
            }
        } else {
            ByteVectorIterator i = this.byteVectorIterator();
            while (i.hasNext()) {
                i.next();
            }
            int j = this.size() - 1;
            while (i.hasPrevious()) {
                if (i.previous() == v) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public ByteVectorIterator byteVectorIterator() {
        return this.byteVectorIterator(0);
    }

    @Override
    public ByteVectorIterator byteVectorIterator(int index) {
        return new VItr();
    }

    @Override
    public ByteVector subVector(int start, int end) {
        if (start < 0 || start >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new SubV(this, start, end);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Byte> c) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i2 = index;
        ++this.modCount;
        if (c.isEmpty()) {
            return false;
        }
        Iterator<? extends Byte> i = c.iterator();
        while (i.hasNext()) {
            this.add(i2++, i.next());
        }
        return true;
    }

    @Override
    public Byte get(int index) {
        return this.getByte(index);
    }

    @Override
    public Byte set(int index, Byte element) {
        return this.setByte(index, element);
    }

    @Override
    public void add(int index, Byte element) {
        this.addByte(index, element);
    }

    @Override
    public Byte remove(int index) {
        return this.removeAt(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Byte) {
            return this.indexOfByte((Byte)o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Byte) {
            return this.lastIndexOfByte((Byte)o);
        }
        return -1;
    }

    @Override
    public ListIterator<Byte> listIterator() {
        final ByteVectorIterator i = this.byteVectorIterator();
        return new ListIterator<Byte>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Byte next() {
                return i.next();
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public Byte previous() {
                return i.previous();
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public void set(Byte e) {
                i.setByte(e);
            }

            @Override
            public void add(Byte e) {
                i.addByte(e);
            }
        };
    }

    @Override
    public ListIterator<Byte> listIterator(int index) {
        return this.listIterator(0);
    }

    @Override
    public List<Byte> subList(int fromIndex, int toIndex) {
        final ByteVector v = this.subVector(fromIndex, toIndex);
        return new AbstractList<Byte>(){

            @Override
            public Byte get(int index) {
                return (Byte)v.get(index);
            }

            @Override
            public int size() {
                return AbstractByteVector.this.size();
            }

            @Override
            public Byte set(int index, Byte element) {
                return v.set(index, element);
            }

            @Override
            public void add(int index, Byte element) {
                v.add(index, element);
            }

            @Override
            public Byte remove(int index) {
                return (Byte)v.remove(index);
            }
        };
    }

    @Override
    public void add(int index, int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        this.addByte(index, (byte)v);
    }

    @Override
    public byte set(int index, int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.setByte(index, (byte)v);
    }

    @Override
    public int indexOf(int v) {
        if (v < -128 || v > 127) {
            return -1;
        }
        return this.indexOfByte((byte)v);
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.toByteArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ByteVector) {
            ByteVector v = (ByteVector)obj;
            if (this.size() != v.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (this.getByte(i) != v.getByte(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof ByteList) {
            ByteIterator i = this.byteIterator();
            ByteIterator j = ((ByteList)obj).byteIterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next() == j.next()) continue;
                return false;
            }
            return !i.hasNext() && !j.hasNext();
        }
        return false;
    }

    private class Itr
    implements ByteIterator {
        int ptr = 0;
        int ptrrem = -1;
        int exModCount;

        private Itr() {
            this.exModCount = AbstractByteVector.this.modCount;
        }

        void checks() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractByteVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        void checks2() {
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            if (this.ptrrem >= AbstractByteVector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractByteVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ptr < AbstractByteVector.this.size();
        }

        @Override
        public byte next() {
            this.checks();
            this.ptrrem = this.ptr;
            return AbstractByteVector.this.getByte(this.ptr++);
        }

        @Override
        public void remove() {
            this.checks2();
            try {
                AbstractByteVector.this.removeAt(this.ptrrem);
                this.exModCount = AbstractByteVector.this.modCount;
                --this.ptr;
                this.ptrrem = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ Itr(Itr itr, Itr itr2) {
            this();
        }
    }

    private static class SubV
    extends AbstractByteVector {
        private ByteVector vector;
        private int bindex;
        private int eindex;

        private SubV(ByteVector vector, int b, int e) {
            this.vector = vector;
            this.bindex = b;
            this.eindex = e;
        }

        @Override
        public void addByte(int index, byte v) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ++this.eindex;
            this.vector.addByte(index + this.bindex, v);
        }

        @Override
        public byte getByte(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.getByte(index + this.bindex);
        }

        @Override
        public byte removeAt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            --this.eindex;
            return this.vector.removeAt(index + this.bindex);
        }

        @Override
        public byte setByte(int index, byte v) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.setByte(index + this.bindex, v);
        }

        @Override
        public int size() {
            return this.eindex - this.bindex;
        }
    }

    private class VItr
    extends Itr
    implements ByteVectorIterator {
        private VItr() {
        }

        @Override
        public void addByte(byte v) {
            if (this.exModCount != AbstractByteVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                this.ptrrem = -1;
                AbstractByteVector.this.addByte(this.ptr++, v);
                this.exModCount = AbstractByteVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr > 0;
        }

        @Override
        public int nextIndex() {
            return this.ptr;
        }

        @Override
        public byte previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractByteVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                byte res = AbstractByteVector.this.getByte(this.ptr);
                this.ptrrem = --this.ptr;
                return res;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this.ptr - 1;
        }

        @Override
        public void setByte(byte v) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            if (this.exModCount != AbstractByteVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractByteVector.this.setByte(this.ptr, v);
                this.ptrrem = -1;
                this.exModCount = AbstractByteVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int v) {
            if (v < -128 || v > 127) {
                throw new IllegalArgumentException();
            }
            this.addByte((byte)v);
        }

        @Override
        public void set(int v) {
            if (v < -128 || v > 127) {
                throw new IllegalArgumentException();
            }
            this.setByte((byte)v);
        }
    }
}

