/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.map;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.util.SimpleMap;

public class NestedMap<K, V>
extends AbstractMap<K, V>
implements SimpleMap<K, V> {
    private Map<K, V> composite;
    private Map<K, V> elems;

    public NestedMap(Map<K, V> elems, Map<K, V> composite) {
        this.elems = elems;
        this.composite = composite;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> res = new HashSet<Map.Entry<K, V>>(this.elems.entrySet());
        if (this.composite != null) {
            for (Map.Entry<K, V> e : this.composite.entrySet()) {
                if (this.elems.containsKey(e.getKey())) continue;
                res.add(e);
            }
        }
        return res;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.elems.containsKey(key)) {
            return true;
        }
        if (this.composite != null) {
            return this.composite.containsKey(key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.elems.containsKey(key)) {
            return this.elems.get(key);
        }
        if (this.composite != null) {
            return this.composite.get(key);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V map(K key) {
        return this.get(key);
    }
}

