/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.Objects;

public final class Iterators {
    public static final ListIterator<Object> NULL = new ListIterator<Object>(){

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    };

    private Iterators() {
    }

    public static <E> ListIterator<E> emptyIterator() {
        return NULL;
    }

    public static <E> E nextNotNull(Iterator<E> iter) {
        E res = null;
        do {
            if (iter.hasNext()) continue;
            return null;
        } while ((res = (E)iter.next()) == null);
        return res;
    }

    public static <E> Iterator<E> unmodifiable(Iterator<E> i) {
        return new Unmodify<E>(i);
    }

    public static <E> Iterator<E> singleton(E o) {
        return new Single<E>(o);
    }

    public static <E> String toString(Iterator<E> i, String delim) {
        StringBuffer buf = new StringBuffer();
        String d2 = "";
        while (i.hasNext()) {
            buf.append(d2);
            buf.append(Objects.toString(i.next()));
            d2 = delim;
        }
        return buf.toString();
    }

    private static class Single<E>
    implements Iterator<E> {
        private E obj;

        Single(E o) {
            this.obj = o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.obj != null;
        }

        @Override
        public E next() {
            E o = this.obj;
            if (o == null) {
                throw new NoSuchElementException();
            }
            this.obj = null;
            return o;
        }
    }

    private static class Unmodify<E>
    implements Iterator<E> {
        Iterator<E> iter;

        Unmodify(Iterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next();
        }
    }
}

