/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;

public class StringToNumber
extends Subr {
    private Datum process(Datum d, int radix, LispMessage mesg) {
        if (d instanceof LispString) {
            LispNumber n = LispNumber.parse(((LispString)d).getString(), radix);
            return n != null ? n : LispBoolean.FALSE;
        }
        throw mesg.getError("err.require.string", d);
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() == 1) {
            return this.process(lst.get(0), 10, mesg);
        }
        if (lst.size() == 2) {
            Datum d = lst.get(1);
            if (d instanceof LispNumber) {
                LispNumber n = (LispNumber)d;
                if (!n.isInteger()) {
                    throw mesg.getError("err.require.smallint", n);
                }
                int ii = SubrUtils.getSmallIntegerExact(n);
                if (ii < 2 || ii > 16) {
                    throw mesg.getError("err.radix.invalid");
                }
                return this.process(lst.get(0), ii, mesg);
            }
            throw mesg.getError("err.require.smallint", d);
        }
        throw mesg.getError("err.argument", this.symbolName);
    }
}

