/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.subr.BinaryArgs;

public class Remainder
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispReal && c2a instanceof LispReal) {
            LispReal r1 = (LispReal)c1a;
            LispReal r2 = (LispReal)c2a;
            if (r1.isInteger() && r2.isInteger()) {
                BigInteger a = r1.getBigInteger();
                BigInteger b = r2.getBigInteger();
                if (b.equals(BigInteger.ZERO)) {
                    throw mesg.getError("err.divbyzero");
                }
                if (r1.isExact() && r2.isExact()) {
                    return LispInteger.valueOf(a.remainder(b));
                }
                return new LispDouble(a.remainder(b).doubleValue());
            }
            if (!r1.isInteger()) {
                throw mesg.getError("err.require.int", r1);
            }
            throw mesg.getError("err.require.int", r2);
        }
        if (!(c1a instanceof LispReal)) {
            throw mesg.getError("err.require.int", c1a);
        }
        throw mesg.getError("err.require.int", c2a);
    }
}

