/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;

public class Atan
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() == 1) {
            Datum d = lst.get(0);
            if (d instanceof LispNumber) {
                return LispMath.atan((LispNumber)d);
            }
            throw mesg.getError("err.require.number", d);
        }
        if (lst.size() == 2) {
            Datum d1 = lst.get(0);
            Datum d2 = lst.get(1);
            if (!(d1 instanceof LispNumber)) {
                throw mesg.getError("err.require.real", d1);
            }
            if (!(d2 instanceof LispNumber)) {
                throw mesg.getError("err.require.real", d2);
            }
            LispNumber n1 = (LispNumber)d1;
            LispNumber n2 = (LispNumber)d2;
            if (n1.isReal() && n2.isReal()) {
                return new LispDouble(Math.atan2(n1.getRealDouble(), n2.getRealDouble()));
            }
            if (!n1.isReal()) {
                throw mesg.getError("err.require.real", n1);
            }
            throw mesg.getError("err.require.real", n2);
        }
        throw mesg.getError("err.argument", "atan");
    }
}

