/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.lisp.datetime.LispDate;
import net.morilib.lisp.datetime.LispTime;
import net.morilib.lisp.sql.LispSQLObjectException;
import net.morilib.sql.util.DBMSDependentException;

public class LispSQLUtils {
    private static LispSQLUtils defaultSQLUtils;
    private static Map<String, LispSQLUtils> sqlUtils;
    private String dbms;

    static {
        sqlUtils = new HashMap<String, LispSQLUtils>();
        defaultSQLUtils = new LispSQLUtils("default");
    }

    protected LispSQLUtils(String dbms) {
        this.dbms = dbms;
        sqlUtils.put(dbms, this);
    }

    public static LispSQLUtils getSQLUtils() {
        return defaultSQLUtils;
    }

    public static void setSQLUtils(String name) {
        LispSQLUtils su = sqlUtils.get(name);
        defaultSQLUtils = su == null ? sqlUtils.get("default") : su;
    }

    protected Datum doGetArray(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispVector(this.getData(rs.getArray(column).getResultSet()));
    }

    protected Datum doGetBigInt(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return LispInteger.valueOf(rs.getBigDecimal(column).toBigInteger());
    }

    protected Datum doGetBinary(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetBit(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetBlob(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetBoolean(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return LispBoolean.getInstance(rs.getBoolean(column));
    }

    protected Datum doGetChar(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispString(rs.getString(column));
    }

    protected Datum doGetClob(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetDatalink(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetDate(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispDate(new java.util.Date(rs.getDate(column).getTime()));
    }

    protected Datum doGetDecimal(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return LispUtils.bigDecimalToRational(rs.getBigDecimal(column));
    }

    protected Datum doGetDistinct(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetDouble(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispDouble(rs.getDouble(column));
    }

    protected Datum doGetFloat(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispDouble(rs.getFloat(column));
    }

    protected Datum doGetInteger(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return LispInteger.valueOf(rs.getInt(column));
    }

    protected Datum doGetJavaDatum(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetLongvarbinary(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetLongvarchar(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetNull(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return null;
    }

    protected Datum doGetNumeric(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return LispUtils.bigDecimalToRational(rs.getBigDecimal(column));
    }

    protected Datum doGetOther(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetReal(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispDouble(rs.getDouble(column));
    }

    protected Datum doGetRef(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetSmallint(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return LispInteger.valueOf(rs.getInt(column));
    }

    protected Datum doGetStruct(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetTime(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispTime(LispTime.TimeType.TIME_DURATION, rs.getDate(column).getTime());
    }

    protected Datum doGetTimestamp(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispDate(new java.util.Date(rs.getTimestamp(column).getTime()));
    }

    protected Datum doGetTinyint(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return LispInteger.valueOf(rs.getInt(column));
    }

    protected Datum doGetVarbinary(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected Datum doGetVarchar(ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        return new LispString(rs.getString(column));
    }

    protected Datum doGetType(int type, ResultSet rs, ResultSetMetaData md, int column) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    public Datum getDatum(ResultSet rs, int column) throws SQLException, DBMSDependentException {
        ResultSetMetaData md = rs.getMetaData();
        int type = md.getColumnType(column);
        if (rs.getObject(column) == null) {
            return Nil.NIL;
        }
        switch (type) {
            case 2003: {
                return this.doGetArray(rs, md, column);
            }
            case -5: {
                return this.doGetBigInt(rs, md, column);
            }
            case -2: {
                return this.doGetBinary(rs, md, column);
            }
            case -7: {
                return this.doGetBit(rs, md, column);
            }
            case 2004: {
                return this.doGetBlob(rs, md, column);
            }
            case 16: {
                return this.doGetBoolean(rs, md, column);
            }
            case 1: {
                return this.doGetChar(rs, md, column);
            }
            case 2005: {
                return this.doGetClob(rs, md, column);
            }
            case 70: {
                return this.doGetDatalink(rs, md, column);
            }
            case 91: {
                return this.doGetDate(rs, md, column);
            }
            case 3: {
                return this.doGetDecimal(rs, md, column);
            }
            case 2001: {
                return this.doGetDistinct(rs, md, column);
            }
            case 8: {
                return this.doGetDouble(rs, md, column);
            }
            case 6: {
                return this.doGetFloat(rs, md, column);
            }
            case 4: {
                return this.doGetInteger(rs, md, column);
            }
            case 2000: {
                return this.doGetJavaDatum(rs, md, column);
            }
            case -4: {
                return this.doGetLongvarbinary(rs, md, column);
            }
            case -1: {
                return this.doGetLongvarchar(rs, md, column);
            }
            case 0: {
                return this.doGetNull(rs, md, column);
            }
            case 2: {
                return this.doGetNumeric(rs, md, column);
            }
            case 1111: {
                return this.doGetOther(rs, md, column);
            }
            case 7: {
                return this.doGetReal(rs, md, column);
            }
            case 2006: {
                return this.doGetRef(rs, md, column);
            }
            case 5: {
                return this.doGetSmallint(rs, md, column);
            }
            case 2002: {
                return this.doGetStruct(rs, md, column);
            }
            case 92: {
                return this.doGetTime(rs, md, column);
            }
            case 93: {
                return this.doGetTimestamp(rs, md, column);
            }
            case -6: {
                return this.doGetTinyint(rs, md, column);
            }
            case -3: {
                return this.doGetVarbinary(rs, md, column);
            }
            case 12: {
                return this.doGetVarchar(rs, md, column);
            }
        }
        return this.doGetType(type, rs, md, column);
    }

    public Datum[] getData(ResultSet rs) throws SQLException, DBMSDependentException {
        ResultSetMetaData md = rs.getMetaData();
        Datum[] res = new Datum[md.getColumnCount()];
        int i = 0;
        while (i < res.length) {
            res[i] = this.getDatum(rs, i + 1);
            ++i;
        }
        return res;
    }

    protected void doUpdateArray(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateBigInt(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispInteger)) {
            throw new LispSQLObjectException();
        }
        rs.updateBigDecimal(column, d.getBigDecimal());
    }

    protected void doUpdateBinary(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateBit(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        rs.updateBoolean(column, d.isTrue());
    }

    protected void doUpdateBlob(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateBoolean(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        rs.updateBoolean(column, d.isTrue());
    }

    protected void doUpdateChar(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        rs.updateString(column, d.getString());
    }

    protected void doUpdateClob(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateDatalink(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateDate(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispDate)) {
            throw new LispSQLObjectException();
        }
        rs.updateDate(column, new Date(((LispDate)d).getTime()));
    }

    protected void doUpdateDecimal(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispReal)) {
            throw new LispSQLObjectException();
        }
        rs.updateBigDecimal(column, d.getBigDecimal());
    }

    protected void doUpdateDistinct(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateDouble(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispReal)) {
            throw new LispSQLObjectException();
        }
        rs.updateDouble(column, d.getRealDouble());
    }

    protected void doUpdateFloat(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispReal)) {
            throw new LispSQLObjectException();
        }
        rs.updateFloat(column, (float)d.getRealDouble());
    }

    protected void doUpdateInteger(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispInteger)) {
            throw new LispSQLObjectException();
        }
        rs.updateInt(column, d.getInt());
    }

    protected void doUpdateJavaDatum(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateLongvarbinary(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateLongvarchar(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateNull(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateNumeric(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispReal)) {
            throw new LispSQLObjectException();
        }
        rs.updateBigDecimal(column, d.getBigDecimal());
    }

    protected void doUpdateOther(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateReal(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispReal)) {
            throw new LispSQLObjectException();
        }
        rs.updateDouble(column, d.getRealDouble());
    }

    protected void doUpdateRef(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateSmallint(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispInteger)) {
            throw new LispSQLObjectException();
        }
        rs.updateShort(column, (short)d.getInt());
    }

    protected void doUpdateStruct(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateTime(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispTime)) {
            throw new LispSQLObjectException();
        }
        rs.updateTime(column, new Time(((LispTime)d).getTimeMillis()));
    }

    protected void doUpdateTimestamp(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof LispDate)) {
            throw new LispSQLObjectException();
        }
        rs.updateTimestamp(column, new Timestamp(((LispDate)d).getTime()));
    }

    protected void doUpdateTinyint(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateVarbinary(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    protected void doUpdateVarchar(ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        rs.updateString(column, d.getString());
    }

    protected void doUpdateType(int type, ResultSet rs, ResultSetMetaData md, int column, Datum d) throws SQLException, DBMSDependentException {
        throw new DBMSDependentException();
    }

    public void updateDatum(ResultSet ps, int column, Datum d) throws SQLException, DBMSDependentException {
        ResultSetMetaData md = ps.getMetaData();
        switch (md.getColumnType(column)) {
            case 2003: {
                this.doUpdateArray(ps, md, column, d);
                break;
            }
            case -5: {
                this.doUpdateBigInt(ps, md, column, d);
                break;
            }
            case -2: {
                this.doUpdateBinary(ps, md, column, d);
                break;
            }
            case -7: {
                this.doUpdateBit(ps, md, column, d);
                break;
            }
            case 2004: {
                this.doUpdateBlob(ps, md, column, d);
                break;
            }
            case 16: {
                this.doUpdateBoolean(ps, md, column, d);
                break;
            }
            case 1: {
                this.doUpdateChar(ps, md, column, d);
                break;
            }
            case 2005: {
                this.doUpdateClob(ps, md, column, d);
                break;
            }
            case 70: {
                this.doUpdateDatalink(ps, md, column, d);
                break;
            }
            case 91: {
                this.doUpdateDate(ps, md, column, d);
                break;
            }
            case 3: {
                this.doUpdateDecimal(ps, md, column, d);
                break;
            }
            case 2001: {
                this.doUpdateDistinct(ps, md, column, d);
                break;
            }
            case 8: {
                this.doUpdateDouble(ps, md, column, d);
                break;
            }
            case 6: {
                this.doUpdateFloat(ps, md, column, d);
                break;
            }
            case 4: {
                this.doUpdateInteger(ps, md, column, d);
                break;
            }
            case 2000: {
                this.doUpdateJavaDatum(ps, md, column, d);
                break;
            }
            case -4: {
                this.doUpdateLongvarbinary(ps, md, column, d);
                break;
            }
            case -1: {
                this.doUpdateLongvarchar(ps, md, column, d);
                break;
            }
            case 0: {
                this.doUpdateNull(ps, md, column, d);
                break;
            }
            case 2: {
                this.doUpdateNumeric(ps, md, column, d);
                break;
            }
            case 1111: {
                this.doUpdateOther(ps, md, column, d);
                break;
            }
            case 7: {
                this.doUpdateReal(ps, md, column, d);
                break;
            }
            case 2006: {
                this.doUpdateRef(ps, md, column, d);
                break;
            }
            case 5: {
                this.doUpdateSmallint(ps, md, column, d);
                break;
            }
            case 2002: {
                this.doUpdateStruct(ps, md, column, d);
                break;
            }
            case 92: {
                this.doUpdateTime(ps, md, column, d);
                break;
            }
            case 93: {
                this.doUpdateTimestamp(ps, md, column, d);
                break;
            }
            case -6: {
                this.doUpdateTinyint(ps, md, column, d);
                break;
            }
            case -3: {
                this.doUpdateVarbinary(ps, md, column, d);
                break;
            }
            case 12: {
                this.doUpdateVarchar(ps, md, column, d);
                break;
            }
            default: {
                this.doUpdateType(md.getColumnType(column), ps, md, column, d);
            }
        }
    }

    public void updateData(ResultSet ps, Datum ... dta) throws SQLException, DBMSDependentException {
        int i = 0;
        while (i < dta.length) {
            this.updateDatum(ps, i + 1, dta[i]);
            ++i;
        }
    }

    protected void doSetString(PreparedStatement ps, int column, String o) throws SQLException, DBMSDependentException {
        ps.setString(column, o);
    }

    protected void doSetInteger(PreparedStatement ps, int column, Integer o) throws SQLException, DBMSDependentException {
        ps.setInt(column, o);
    }

    protected void doSetBigInteger(PreparedStatement ps, int column, BigInteger o) throws SQLException, DBMSDependentException {
        ps.setBigDecimal(column, new BigDecimal(o));
    }

    protected void doSetDate(PreparedStatement ps, int column, java.util.Date o) throws SQLException, DBMSDependentException {
        try {
            ps.setTimestamp(column, new Timestamp(o.getTime()));
        }
        catch (SQLException e) {
            ps.setDate(column, new Date(o.getTime()));
        }
    }

    protected void doSetFloat(PreparedStatement ps, int column, Float o) throws SQLException, DBMSDependentException {
        try {
            ps.setFloat(column, o.floatValue());
        }
        catch (SQLException e) {
            ps.setDouble(column, o.doubleValue());
        }
    }

    protected void doSetDouble(PreparedStatement ps, int column, Double o) throws SQLException, DBMSDependentException {
        try {
            ps.setDouble(column, o);
        }
        catch (SQLException e) {
            ps.setFloat(column, o.floatValue());
        }
    }

    protected void doSetBoolean(PreparedStatement ps, int column, Boolean o) throws SQLException, DBMSDependentException {
        ps.setBoolean(column, o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameter(PreparedStatement ps, int column, Datum d) throws SQLException, DBMSDependentException {
        if (!(d instanceof JavaObjective)) throw new DBMSDependentException();
        Object o = ((JavaObjective)((Object)d)).toObject();
        if (o == null) {
            ps.setObject(column, null);
            return;
        } else if (o instanceof String) {
            this.doSetString(ps, column, (String)o);
            return;
        } else if (o instanceof Integer) {
            this.doSetInteger(ps, column, (Integer)o);
            return;
        } else if (o instanceof BigInteger) {
            this.doSetBigInteger(ps, column, (BigInteger)o);
            return;
        } else if (o instanceof java.util.Date) {
            this.doSetDate(ps, column, (java.util.Date)o);
            return;
        } else if (o instanceof Boolean) {
            this.doSetBoolean(ps, column, (Boolean)o);
            return;
        } else if (o instanceof Float) {
            this.doSetFloat(ps, column, (Float)o);
            return;
        } else {
            if (!(o instanceof Double)) throw new DBMSDependentException();
            this.doSetDouble(ps, column, (Double)o);
        }
    }

    public void setParameters(PreparedStatement ps, Datum ... dta) throws SQLException, DBMSDependentException {
        int i = 0;
        while (i < dta.length) {
            this.setParameter(ps, i + 1, dta[i]);
            ++i;
        }
    }

    public String getDbms() {
        return this.dbms;
    }
}

