/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.sql.SQLException;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;

public class LispSQLException
extends LispException {
    private static final long serialVersionUID = 1349654199831740484L;
    private static final String ERR_CD = "err.jdbc.sqlerror";
    private SQLException sqlException;

    private LispSQLException(String code, String message, SQLException cause) {
        super(code, message, cause);
        this.sqlException = cause;
    }

    public static LispSQLException getError(LispMessage mesg, SQLException cause) {
        return new LispSQLException(ERR_CD, mesg.get(ERR_CD), cause);
    }

    LispSQLException getNextException(LispMessage mesg) {
        return LispSQLException.getError(mesg, this.sqlException.getNextException());
    }

    public int getSQLErrorCode() {
        return this.sqlException.getErrorCode();
    }

    public String getSQLState() {
        return this.sqlException.getSQLState();
    }

    @Override
    public SQLException getException() {
        return this.sqlException;
    }
}

