/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.OutputPort;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.LispClientSocket;

public class SocketOutputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        try {
            if (l.size() == 1) {
                Datum c1a = l.get(0);
                if (c1a instanceof LispClientSocket) {
                    LispClientSocket lcs = (LispClientSocket)c1a;
                    OutputStream ins = lcs.socket.getOutputStream();
                    return new OutputPort(new OutputStreamWriter(ins), mesg);
                }
                throw mesg.getError("err.net.require.clientsocket", c1a);
            }
            if (l.size() == 2) {
                Datum c1a = l.get(0);
                Datum c2a = l.get(1);
                LispClientSocket lcs = (LispClientSocket)c1a;
                OutputStream ins = lcs.socket.getOutputStream();
                if (!(c1a instanceof LispClientSocket)) {
                    throw mesg.getError("err.net.require.clientsocket", c1a);
                }
                if (!(c2a instanceof LispString)) {
                    throw mesg.getError("err.require.string", c2a);
                }
                String enc = c2a.getString();
                try {
                    return new OutputPort(new OutputStreamWriter(ins, enc), mesg);
                }
                catch (UnsupportedEncodingException e) {
                    throw mesg.getError("err.unsupportedencoding", enc);
                }
            }
            throw mesg.getError("err.argument", body);
        }
        catch (IOException e) {
            throw mesg.getError("err.io");
        }
    }
}

