/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math;

import net.morilib.lisp.Symbol;
import net.morilib.lisp.math.LispExact1Function;
import net.morilib.lisp.math.LispNumberField;
import net.morilib.lisp.math.LispPolynomial1;
import net.morilib.math.functions.RationalFunction1Coefficients;

public class LispRationalFunction1
extends LispExact1Function {
    private RationalFunction1Coefficients<LispNumberField> rational;
    private Symbol symbol;

    public LispRationalFunction1(RationalFunction1Coefficients<LispNumberField> rational, Symbol symbol) {
        super(symbol);
        this.rational = rational;
    }

    public RationalFunction1Coefficients<LispNumberField> getRationalFunction() {
        return this.rational;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isUnit() {
        return this.rational.isUnit();
    }

    @Override
    public boolean isZero() {
        return this.rational.isZero();
    }

    @Override
    public LispExact1Function negate() {
        return new LispRationalFunction1((RationalFunction1Coefficients<LispNumberField>)this.rational.negate(), this.symbol);
    }

    @Override
    public LispExact1Function subtract(LispExact1Function x) {
        return null;
    }

    @Override
    public LispExact1Function add(LispExact1Function x) {
        return null;
    }

    @Override
    public LispExact1Function multiply(int n) {
        return new LispRationalFunction1((RationalFunction1Coefficients<LispNumberField>)this.rational.multiply(n), this.symbol);
    }

    @Override
    public LispExact1Function multiply(LispExact1Function x) {
        return null;
    }

    @Override
    public LispExact1Function power(int n) {
        return new LispRationalFunction1((RationalFunction1Coefficients<LispNumberField>)this.rational.power(n), this.symbol);
    }

    @Override
    public LispExact1Function invert() {
        if (this.rational.getNumerator().isUnit()) {
            return new LispPolynomial1(this.rational.getDenominator(), this.symbol);
        }
        return new LispRationalFunction1((RationalFunction1Coefficients<LispNumberField>)this.rational.invert(), this.symbol);
    }

    @Override
    public LispExact1Function divide(LispExact1Function x) {
        return null;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + this.symbol.hashCode());
        r = 37 * (r + this.rational.hashCode());
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispRationalFunction1) {
            LispRationalFunction1 p = (LispRationalFunction1)obj;
            return this.symbol.equals(p.symbol) && this.rational.equals(p.rational);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.rational.toString(this.symbol.getName());
    }
}

