/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.datetime;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.datetime.LispTime;

public abstract class TimeCompare
extends Subr {
    protected abstract boolean compare(LispTime var1, LispTime var2);

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 2) {
            throw mesg.getError("err.argument", body);
        }
        if (!(lst.get(0) instanceof LispTime)) {
            throw mesg.getError("err.require.char", lst.get(0));
        }
        LispTime prev = (LispTime)lst.get(0);
        int i = 1;
        while (i < lst.size()) {
            LispTime td;
            Datum d = lst.get(i);
            if (d instanceof LispTime) {
                td = (LispTime)d;
                if (!prev.getTimeType().equals((Object)td.getTimeType())) {
                    throw mesg.getError("err.srfi19.differenttimetype");
                }
                if (!this.compare(prev, td)) {
                    return LispBoolean.FALSE;
                }
            } else {
                throw mesg.getError("err.srfi19.require.time", d);
            }
            prev = td;
            ++i;
        }
        return LispBoolean.TRUE;
    }
}

