/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.datetime;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.morilib.lang.algebra.Subtractable;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.Symbol;

public class LispTime
extends Datum
implements Cloneable,
Comparable<LispTime>,
Subtractable<LispTime> {
    private static final long UTC_TO_TAI = -34000L;
    private static final BigInteger THOUSAND = BigInteger.valueOf(1000L);
    static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static long processEpoch;
    private static ThreadLocal<Long> threadEpoch;
    static final Map<Datum, TimeType> SYM_TO_TYPE;
    long time;
    private TimeType type;

    static {
        threadEpoch = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return System.currentTimeMillis();
            }
        };
        HashMap<Symbol, TimeType> symToType = new HashMap<Symbol, TimeType>();
        symToType.put(Symbol.getSymbol("time-utc"), TimeType.TIME_UTC);
        symToType.put(Symbol.getSymbol("time-tai"), TimeType.TIME_TAI);
        symToType.put(Symbol.getSymbol("time-monotonic"), TimeType.TIME_MONOTONIC);
        symToType.put(Symbol.getSymbol("time-duration"), TimeType.TIME_DURATION);
        symToType.put(Symbol.getSymbol("time-process"), TimeType.TIME_PROCESS);
        symToType.put(Symbol.getSymbol("time-thread"), TimeType.TIME_THREAD);
        SYM_TO_TYPE = Collections.unmodifiableMap(symToType);
    }

    public LispTime(TimeType type, long time) {
        this.type = type;
        this.time = time;
        if (this.time > 9223372036854775L) {
            this.time = Long.MAX_VALUE;
        } else if (this.time < -9223372036854775L) {
            this.time = Long.MIN_VALUE;
        }
    }

    public LispTime(TimeType type, LispReal sec) {
        this.type = type;
        this.setSecond2(sec);
    }

    public LispTime(TimeType type, long sec, int nanos) {
        this(type, sec * 1000L + (long)(nanos / 1000000));
    }

    public static void initilizeProcessEpoch() {
        processEpoch = System.currentTimeMillis();
    }

    public static LispTime currentUTCTime() {
        return new LispTime(TimeType.TIME_UTC, System.currentTimeMillis());
    }

    public static LispTime currentTAITime() {
        return new LispTime(TimeType.TIME_TAI, System.currentTimeMillis() + -34000L);
    }

    public static LispTime currentMonotonicTime() {
        return LispTime.currentUTCTime();
    }

    public static LispTime currentProcessTime() {
        return new LispTime(TimeType.TIME_TAI, System.currentTimeMillis() - processEpoch);
    }

    public static LispTime currentThreadTime() {
        return new LispTime(TimeType.TIME_TAI, System.currentTimeMillis() - threadEpoch.get());
    }

    public static LispTime toUTCTime(Date d) {
        return new LispTime(TimeType.TIME_UTC, d.getTime());
    }

    public static LispTime toTAITime(Date d) {
        return new LispTime(TimeType.TIME_TAI, d.getTime() - -34000L);
    }

    public static LispTime toMonotonicTime(Date d) {
        return new LispTime(TimeType.TIME_MONOTONIC, d.getTime());
    }

    public static LispTime toProcessTime(Date d) {
        return new LispTime(TimeType.TIME_TAI, d.getTime() - processEpoch);
    }

    public static LispTime toThreadTime(Date d) {
        return new LispTime(TimeType.TIME_TAI, d.getTime() - threadEpoch.get());
    }

    public LispTime toUTCTime() {
        switch (this.type) {
            case TIME_UTC: 
            case TIME_MONOTONIC: {
                return this.clone();
            }
            case TIME_TAI: {
                return new LispTime(TimeType.TIME_UTC, this.time + -34000L);
            }
            case TIME_PROCESS: {
                return new LispTime(TimeType.TIME_UTC, this.time + processEpoch);
            }
            case TIME_THREAD: {
                return new LispTime(TimeType.TIME_UTC, this.time + threadEpoch.get());
            }
            case TIME_DURATION: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalStateException();
    }

    public LispTime toTAITime() {
        switch (this.type) {
            case TIME_UTC: 
            case TIME_MONOTONIC: {
                return new LispTime(TimeType.TIME_TAI, this.time - -34000L);
            }
            case TIME_TAI: {
                return this.clone();
            }
            case TIME_PROCESS: {
                return new LispTime(TimeType.TIME_TAI, this.time + processEpoch - -34000L);
            }
            case TIME_THREAD: {
                return new LispTime(TimeType.TIME_TAI, this.time + threadEpoch.get() - -34000L);
            }
            case TIME_DURATION: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalStateException();
    }

    public LispTime toMonotonicTime() {
        switch (this.type) {
            case TIME_UTC: 
            case TIME_MONOTONIC: {
                return this.clone();
            }
            case TIME_TAI: {
                return new LispTime(TimeType.TIME_MONOTONIC, this.time + -34000L);
            }
            case TIME_PROCESS: {
                return new LispTime(TimeType.TIME_MONOTONIC, this.time + processEpoch);
            }
            case TIME_THREAD: {
                return new LispTime(TimeType.TIME_MONOTONIC, this.time + threadEpoch.get());
            }
            case TIME_DURATION: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalStateException();
    }

    public void toUTCTimeSet() {
        switch (this.type) {
            case TIME_UTC: 
            case TIME_MONOTONIC: {
                break;
            }
            case TIME_TAI: {
                this.time += -34000L;
                break;
            }
            case TIME_PROCESS: {
                this.time += processEpoch;
                break;
            }
            case TIME_THREAD: {
                this.time += threadEpoch.get().longValue();
                break;
            }
            case TIME_DURATION: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.type = TimeType.TIME_UTC;
    }

    public void toTAITimeSet() {
        switch (this.type) {
            case TIME_UTC: 
            case TIME_MONOTONIC: {
                this.time -= -34000L;
                break;
            }
            case TIME_TAI: {
                break;
            }
            case TIME_PROCESS: {
                this.time = this.time + processEpoch - -34000L;
                break;
            }
            case TIME_THREAD: {
                this.time = this.time + threadEpoch.get() - -34000L;
                break;
            }
            case TIME_DURATION: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.type = TimeType.TIME_TAI;
    }

    public void toMonotonicTimeSet() {
        switch (this.type) {
            case TIME_UTC: 
            case TIME_MONOTONIC: {
                break;
            }
            case TIME_TAI: {
                this.time += -34000L;
                break;
            }
            case TIME_PROCESS: {
                this.time += processEpoch;
                break;
            }
            case TIME_THREAD: {
                this.time += threadEpoch.get().longValue();
                break;
            }
            case TIME_DURATION: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.type = TimeType.TIME_MONOTONIC;
    }

    public TimeType getTimeType() {
        return this.type;
    }

    public int getNanosecond() {
        return (int)(this.time % 1000L) * 1000000;
    }

    public long getSecond() {
        return this.time / 1000L;
    }

    public void setTimeType(TimeType type) {
        this.type = type;
    }

    public void setNanosecond(int nanos) {
        this.time += (long)(nanos / 1000000);
    }

    public void setSecond(long sec) {
        this.time = sec > 9223372036854775L ? Long.MAX_VALUE : (sec < -9223372036854775L ? Long.MIN_VALUE : (this.time += sec * 1000L));
    }

    public LispExactReal getSecond2() {
        return LispRational.newRational(BigInteger.valueOf(this.time), THOUSAND);
    }

    public void setSecond2(LispReal sec) {
        LispExactReal r = !sec.isExact() ? sec.toExact() : (LispExactReal)sec;
        BigInteger b = r.getBigInteger().multiply(THOUSAND);
        this.time = b.compareTo(MAX_LONG) > 0 ? Long.MAX_VALUE : (b.compareTo(MIN_LONG) < 0 ? Long.MIN_VALUE : r.getLong());
    }

    public long getTimeMillis() {
        return this.time;
    }

    public static int getTimeResolution(TimeType type) {
        return 1000000;
    }

    @Override
    public LispTime add(LispTime x) {
        if (!x.type.equals((Object)TimeType.TIME_DURATION)) {
            throw new IllegalArgumentException();
        }
        return new LispTime(this.type, this.time + x.time);
    }

    @Override
    public LispTime multiply(int n) {
        if (!this.type.equals((Object)TimeType.TIME_DURATION)) {
            throw new IllegalArgumentException();
        }
        return new LispTime(this.type, this.time * (long)n);
    }

    @Override
    public LispTime subtract(LispTime t) {
        if (this.type.equals((Object)t.type)) {
            return new LispTime(TimeType.TIME_DURATION, this.time - t.time);
        }
        if (t.type.equals((Object)TimeType.TIME_DURATION)) {
            return new LispTime(this.type, this.time - t.time);
        }
        throw new IllegalArgumentException();
    }

    public void addAssign(LispTime x) {
        if (!x.type.equals((Object)TimeType.TIME_DURATION)) {
            throw new IllegalArgumentException();
        }
        this.time += x.time;
    }

    public void subtractAssign(LispTime t) {
        if (this.type.equals((Object)t.type)) {
            this.type = TimeType.TIME_DURATION;
            this.time -= t.time;
        } else if (t.type.equals((Object)TimeType.TIME_DURATION)) {
            this.time -= t.time;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public LispTime clone() {
        return new LispTime(this.type, this.time);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<time ").append(this.time).append(">");
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + this.type.hashCode());
        r = 37 * (r + (int)this.time);
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispTime) {
            LispTime o = (LispTime)obj;
            return this.type.equals((Object)o.type) && this.time == o.time;
        }
        return false;
    }

    @Override
    public int compareTo(LispTime o) {
        if (this.type.equals((Object)o.type)) {
            return this.time < o.time ? -1 : (this.time > o.time ? 1 : 0);
        }
        throw new IllegalArgumentException();
    }

    public static enum TimeType {
        TIME_UTC(Symbol.getSymbol("time-utc")),
        TIME_TAI(Symbol.getSymbol("time-tai")),
        TIME_MONOTONIC(Symbol.getSymbol("time-monotonic")),
        TIME_DURATION(Symbol.getSymbol("time-duration")),
        TIME_PROCESS(Symbol.getSymbol("time-process")),
        TIME_THREAD(Symbol.getSymbol("time-thread"));

        private Datum symbol;

        private TimeType(Datum d) {
            this.symbol = d;
        }

        public Datum getSymbol() {
            return this.symbol;
        }
    }
}

