/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.datetime;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.morilib.lisp.Datum;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.datetime.LispTime;
import net.morilib.util.datetime.JulianDay;

public class LispDate
extends Datum
implements JavaObjective {
    private Calendar calendar = new GregorianCalendar();

    public LispDate() {
    }

    public LispDate(int offsetSecond) {
        this.calendar.set(15, offsetSecond * 1000);
    }

    public LispDate(Date d) {
        this.calendar.setTime(d);
    }

    public LispDate(long time) {
        this.calendar.setTimeInMillis(time);
    }

    public LispDate(long time, int offsetSecond) {
        this.calendar.setTimeInMillis(time);
        this.calendar.set(15, offsetSecond * 1000);
    }

    LispDate(LispTime t) {
        this(t.time);
    }

    LispDate(LispTime t, int offsetSecond) {
        this(t.toMonotonicTime().time, offsetSecond);
    }

    public LispDate(Date d, int offsetSecond) {
        this.calendar.setTime(d);
        this.calendar.set(15, offsetSecond * 1000);
    }

    public LispDate(int nanosecond, int second, int minute, int hour, int day, int month, int year, int zoneOffset) {
        this.calendar.set(14, nanosecond / 1000000);
        this.calendar.set(13, second);
        this.calendar.set(12, minute);
        this.calendar.set(11, hour);
        this.calendar.set(5, day);
        this.calendar.set(2, month - 1);
        this.calendar.set(1, year);
        this.calendar.set(15, zoneOffset * 1000);
    }

    public JulianDay getJulianDay() {
        return new JulianDay(this.calendar.getTimeInMillis());
    }

    public int getNanosecond() {
        return this.calendar.get(14) * 1000000;
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getZoneOffset() {
        return this.calendar.get(15) / 1000;
    }

    public int getDayOfYear() {
        return this.calendar.get(6);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7) - 1;
    }

    public int getWeekOfYear(int firstDay) {
        Calendar cal = (Calendar)this.calendar.clone();
        cal.setFirstDayOfWeek(firstDay + 1);
        cal.setMinimalDaysInFirstWeek(7);
        return cal.get(3);
    }

    public Date getDate() {
        return new Date(this.calendar.getTimeInMillis());
    }

    public long getTime() {
        return this.calendar.getTimeInMillis();
    }

    @Override
    public Object toObject() {
        return this.getDate();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<date ").append(this.calendar.getTime().toString()).append(">");
    }

    public int hashCode() {
        return (int)this.calendar.getTimeInMillis();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispDate) {
            return this.getTime() == ((LispDate)obj).getTime();
        }
        return false;
    }
}

