/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;

public class OutputPort
extends Datum {
    private Writer writer;
    private PrintWriter lineWriter;
    private boolean standard;
    private boolean closed = false;
    private LispMessage msg;

    private OutputPort(Writer wr, boolean std, LispMessage msg) {
        if (wr instanceof PrintWriter) {
            this.lineWriter = (PrintWriter)wr;
            this.writer = this.lineWriter;
        } else {
            this.writer = wr;
            this.lineWriter = new PrintWriter(this.writer);
        }
        this.standard = std;
        this.msg = msg;
    }

    public OutputPort(PrintWriter wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(BufferedWriter wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(Writer wr, LispMessage msg) {
        this(new BufferedWriter(wr), false, msg);
    }

    public OutputPort(String fname, LispMessage msg) {
        try {
            OutputStreamWriter wr = new OutputStreamWriter(new FileOutputStream(fname));
            this.writer = new BufferedWriter(wr);
            this.lineWriter = new PrintWriter(this.writer);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public OutputPort(String fname, String encoding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(fname), encoding);
            this.writer = new BufferedWriter(wr);
            this.lineWriter = new PrintWriter(this.writer);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    static OutputPort getStringPort(LispMessage msg) {
        return new OutputPort(new StringWriter(), false, msg);
    }

    public static OutputPort getStandard(LispMessage msg) {
        return new OutputPort(new OutputStreamWriter(System.out), true, msg);
    }

    public void writeChar(LispCharacter ch) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        try {
            if (this.standard) {
                System.out.print(ch.getCharacter());
            } else {
                this.writer.write(ch.getCharacter());
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public void write(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.getResult(d));
        } else {
            this.lineWriter.print(LispUtils.getResult(d));
        }
    }

    public void display(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.print(d));
        } else {
            this.lineWriter.print(LispUtils.print(d));
        }
    }

    public void newline() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.println();
        } else {
            this.lineWriter.println();
        }
    }

    public void close() {
        try {
            if (!this.closed && !this.standard) {
                this.writer.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    @Override
    public boolean isTypePort() {
        return true;
    }

    public boolean isStringPort() {
        return this.writer instanceof StringWriter;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getOutputString() {
        if (this.isStringPort()) {
            return new String(this.writer.toString());
        }
        throw new IllegalStateException();
    }
}

