/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.sos.LispType;

public class LispVector
extends Datum {
    private List<Datum> vec;
    private static final List<Datum> _EMPTY = Collections.emptyList();
    public static final LispVector EMPTY = new LispVector(_EMPTY);

    public LispVector(List<Datum> vec) {
        if (vec == null) {
            throw new NullPointerException();
        }
        this.vec = vec;
    }

    public LispVector(Datum ... data) {
        this(Arrays.asList(data));
    }

    public LispVector() {
        this(new ArrayList<Datum>());
    }

    public Datum get(int index) {
        return this.vec.get(index);
    }

    void set(int index, Datum d) {
        this.vec.set(index, d);
    }

    public int size() {
        return this.vec.size();
    }

    public Datum toConsList() {
        return LispUtils.listToCons(this.vec);
    }

    @Override
    public String toString() {
        return LispUtils.getResult(this);
    }

    @Override
    public boolean isTypeVector() {
        return true;
    }

    @Override
    public List<Datum> getList() {
        return Collections.unmodifiableList(this.vec);
    }

    @Override
    public LispType getType() {
        return LispType.VECTOR;
    }
}

