/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Atom;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.sos.LispType;

public final class LispString
extends Atom
implements JavaObjective {
    public static final LispString EMPTY = new LispString("");
    private String value;

    public LispString(String value) {
        if (value == null) {
            throw new NullPointerException("string is null");
        }
        this.value = value;
    }

    public boolean isEqualTo(LispString a) {
        return this.value.equals(a.value);
    }

    @Override
    public String getString() {
        return this.value;
    }

    void setString(String value) {
        this.value = value;
    }

    @Override
    public LispString toLispString() {
        return this;
    }

    @Override
    public String print() {
        return this.value;
    }

    @Override
    public String getResult() {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.value.length()) {
            char c = this.value.charAt(i);
            if (c == '\\') {
                b.append("\\\\");
            } else if (c == '\"') {
                b.append("\\\"");
            } else {
                b.append(c);
            }
            ++i;
        }
        return "\"" + b.toString() + "\"";
    }

    @Override
    public boolean isTypeString() {
        return true;
    }

    @Override
    public LispType getType() {
        return LispType.STRING;
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispString) {
            return this.value.equals(((LispString)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        return "\"" + this.value + "\"";
    }
}

