/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalFieldElement;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.sos.LispType;

public abstract class LispReal
extends LispNumber
implements Comparable<LispReal>,
NumericalFieldElement<LispReal> {
    private static final Integer2 _I_MAX = Integer2.valueOf(Integer.MAX_VALUE);
    private static final Integer2 _I_MIN = Integer2.valueOf(Integer.MIN_VALUE);
    private static final Integer2 _S_MAX = Integer2.valueOf(Short.MAX_VALUE);
    private static final Integer2 _S_MIN = Integer2.valueOf(Short.MIN_VALUE);
    private static final Integer2 _B_MAX = Integer2.valueOf(127);
    private static final Integer2 _B_MIN = Integer2.valueOf(-128);
    private static final Integer2 _L_MAX = Integer2.valueOf(Long.MAX_VALUE);
    private static final Integer2 _L_MIN = Integer2.valueOf(Long.MIN_VALUE);

    public static LispReal rationalize(LispReal r1, LispReal r2) {
        if (r1.isNaN() || r2.isNaN()) {
            return LispDouble.NaN;
        }
        if (r1.isInfinity()) {
            return r2.isInfinity() ? LispDouble.NaN : r1;
        }
        if (r2.isInfinity()) {
            return r1.isInfinity() ? LispDouble.NaN : LispDouble.ZERO;
        }
        LispExactReal res = LispRational.valueOf(Rational.rationalize(r1.toExact().toRational(), r2.toExact().toRational()));
        if (r1.isExact() && r2.isExact()) {
            return res;
        }
        return res.toInexact();
    }

    @Override
    public LispReal getReal() {
        return this;
    }

    @Override
    public double getImagDouble() {
        return 0.0;
    }

    @Override
    public LispReal getImag() {
        if (this.isNaN()) {
            return LispDouble.NaN;
        }
        if (this.isExact()) {
            return LispInteger.ZERO;
        }
        return LispDouble.ZERO;
    }

    @Override
    public int compareTo(LispReal o) {
        return this.isLessThan(o) ? -1 : (this.isMoreThan(o) ? 1 : 0);
    }

    public abstract boolean isLessThan(LispReal var1);

    public abstract boolean isMoreThan(LispReal var1);

    public abstract int signum();

    @Override
    public abstract LispExactReal toExact();

    @Override
    public abstract LispReal toInexact();

    public abstract boolean isInfinity();

    @Override
    public LispType getType() {
        return LispType.REAL;
    }

    @Override
    public LispReal negate() {
        return (LispReal)this.uminus();
    }

    @Override
    public LispReal divide(LispReal x) {
        return (LispReal)this.div(x);
    }

    @Override
    public LispReal multiply(LispReal x) {
        return (LispReal)this.mul(x);
    }

    @Override
    public LispReal subtract(LispReal x) {
        return (LispReal)this.sub(x);
    }

    @Override
    public LispReal add(LispReal x) {
        return (LispReal)this.add((LispNumber)x);
    }

    @Override
    public byte byteFloor() {
        return (byte)this.intFloor();
    }

    @Override
    public short shortFloor() {
        return (short)this.intFloor();
    }

    @Override
    public byte byteCeil() {
        return (byte)this.intCeil();
    }

    @Override
    public short shortCeil() {
        return (short)this.intCeil();
    }

    @Override
    public boolean inByteRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_B_MAX) <= 0 && f.compareTo(_B_MIN) >= 0;
    }

    @Override
    public boolean inShortRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_S_MAX) <= 0 && f.compareTo(_S_MIN) >= 0;
    }

    @Override
    public boolean inIntRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_I_MAX) <= 0 && f.compareTo(_I_MIN) >= 0;
    }

    @Override
    public boolean inLongRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_L_MAX) <= 0 && f.compareTo(_L_MIN) >= 0;
    }
}

