/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrPredicate;
import net.morilib.lisp.subr.UnaryArgs;

public class ExceptionObject
extends Datum {
    private LispException exception;

    ExceptionObject(LispException exception) {
        this.exception = exception;
    }

    public LispException getException() {
        return this.exception;
    }

    public static class IsException
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof ExceptionObject);
        }
    }

    public static class IsExceptionCode
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof ExceptionObject)) {
                throw mesg.getError("err.require.exception", c1a);
            }
            if (!(c2a instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", c2a);
            }
            ExceptionObject e = (ExceptionObject)c1a;
            String s = ((Symbol)c2a).getName();
            return LispBoolean.getInstance(e.exception.getErrorCode().equals(s));
        }
    }

    public static abstract class IsExceptionType
    extends SubrPredicate {
        protected abstract boolean validate(String var1);

        @Override
        protected boolean test(Datum d) {
            if (d instanceof ExceptionObject) {
                return this.validate(((ExceptionObject)d).exception.getErrorCode());
            }
            return false;
        }
    }
}

