/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Macro;
import net.morilib.lisp.MacroDefinition;
import net.morilib.lisp.Nil;
import net.morilib.lisp.PatternDepthException;
import net.morilib.lisp.PatternDepthMap;
import net.morilib.lisp.PatternMatch;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.SynDefineMacro;
import net.morilib.lisp.SynQuasisyntax;
import net.morilib.lisp.SynQuote;
import net.morilib.lisp.SynSetS;
import net.morilib.lisp.SynSyntax;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.UserSyntax;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

class CompilerImpl
extends LispCompiler {
    private LispMessage message;
    private static final Scheme AUX_S = new Scheme(Scheme.newRnRSEnv(5), LispMessage.getInstance());

    static {
        AUX_S.set("samescp?", new EqWithSyn());
        AUX_S.set("remvscp", new RmWithSyn());
        AUX_S.exec("(define (mapv f vec)  (let ((v1 (make-vector (vector-length vec))))    (let loop ((i (vector-length vec)))      (cond ((zero? i) v1)            (else              (vector-set!                v1                (- i 1)                (f (vector-ref vec (- i 1))))              (loop (- i 1)))))))");
        AUX_S.exec("(define (asss x lis)  (cond ((null? lis) #f)        ((not (pair? (car lis)))          (error (get-default-message            'err.require.pair)))        ((samescp? (caar lis) x) (car lis))        (else (asss x (cdr lis)))))");
        AUX_S.exec("(define (letren x) (lren0 x '() #f))");
        AUX_S.exec("(define (lren0 x as lv)  (cond ((and (not lv)              (pair? x)              (memq (remvscp (car x)) '(let letrec)))          (if (symbol? (cadr x))              (chletn x                      as                      (cons                        (cons (cadr x)                              (remvscp (cadr x)))                        (append                          (makeasc (caddr x))                          as))                      lv)              (chlet  x                      as                      (append (makeasc (cadr x)) as)                      lv)))        ((and (not lv)              (pair? x)              (memq (remvscp (car x)) '(let* letrec*)))          (chlet* x                  as                  (append (makeasc (cadr x)) as)                  lv))        ((and (not lv)              (pair? x)              (memq (remvscp (car x)) '(lambda)))          (let ((as2 (append (makeascl (cadr x)) as)))            (cons (car x)             (cons (lren0 (cadr x) as2 lv)              (lren0 (cddr x) as2 lv)))))        ((pair? x)          (cons (lren0 (car x) as lv)                (lren0 (cdr x) as lv)))        ((vector? x)          (mapv (lambda (x) (lren0 x as lv)) x))        ((and (not lv) (asss x as))          (cdr (asss x as)))        (else x)))");
        AUX_S.exec("(define (makeasc x)  (cond ((null? x) '())        (else (cons (cons (caar x)                          (remvscp (caar x)))                    (makeasc (cdr x))))))");
        AUX_S.exec("(define (makeascl x)  (cond ((null? x) '())        (else         (cons (cons (car x) (remvscp (car x)))          (makeascl (cdr x))))))");
        AUX_S.exec("(define (chlet x a0 as lv)  (cons (car x)        (cons (map (lambda (x)                     (cons (asssif (car x) as)                           (lren0 (cdr x) a0 lv)))                   (cadr x))              (lren0 (cddr x) as lv))))");
        AUX_S.exec("(define (chlet*-aux x a0 lv)  (cond ((null? x) '())        (else          (cons            (cons (remvscp (caar x))                  (lren0 (cdar x) a0 lv))            (chlet*-aux              (cdr x)              (cons                (cons (caar x) (remvscp (caar x)))                a0)              lv)))))");
        AUX_S.exec("(define (chlet* x a0 as lv)  (cons (car x)        (cons (chlet*-aux (cadr x) a0 lv)              (lren0 (cddr x) as lv))))");
        AUX_S.exec("(define (chletn x a0 as lv)  (cons (car x) #;(asssif (car x) as)        (cons (asssif (cadr x) as)              (cons (map (lambda (x)                           (cons (asssif (car x) as)                                 (lren0                                   (cdr x) a0 lv)))                         (caddr x))                    (lren0 (cdddr x) as lv)))))");
        AUX_S.exec("(define (asssif x as)  (if (asss x as) (cdr (asss x as)) x))");
    }

    CompilerImpl(LispMessage msg) {
        this.message = msg;
    }

    @Override
    Datum expandSyntax(UserSyntax syn, Datum body, Environment env2) {
        PatternDepthMap mp;
        List<Datum> pat = syn.getPatternList();
        List<Datum> tmp = syn.getTemplateList();
        boolean mtc = false;
        int ind = 0;
        do {
            mp = new PatternDepthMap(syn.getParamList().get(ind));
        } while (!(mtc = PatternMatch.match(pat.get(ind), body, mp, syn.getReservedSet())) && ++ind < pat.size());
        if (mtc) {
            try {
                Environment menv = new Environment();
                HashMap<Symbol, Symbol> box = new HashMap<Symbol, Symbol>();
                Datum t = tmp.get(ind);
                Datum tpl = PatternMatch.compileTemplate(t, mp);
                Datum res = PatternMatch.expand(tpl, mp, syn, box, env2);
                res = this.replaceLocalVals(res, env2, menv, true, 0);
                res = PatternMatch.appendScope(res, mp, syn);
                res = PatternMatch.markReplace(box, res, false);
                res = PatternMatch.gtUnwrap(res);
                return res;
            }
            catch (PatternDepthException e) {
                e.printStackTrace();
                throw this.message.getError("err.wronglevel", e.getMessage());
            }
        }
        throw this.message.getError("err.malform", syn.getName());
    }

    private Datum expandLambda(UserSyntax syn, Datum body, Environment env2, CodeExecutor exec, IntStack memento) {
        CompiledCode.Builder mbuild = new CompiledCode.Builder();
        ClosureClass clm = new ClosureClass(Nil.NIL, syn.getLambda());
        mbuild.addPush(clm);
        mbuild.addBeginList();
        mbuild.addEndList();
        mbuild.addCall();
        mbuild.addBeginList();
        mbuild.addPush(body);
        mbuild.addAppendList();
        mbuild.addEndList();
        mbuild.addCall();
        mbuild.addReturnOp();
        Datum res = exec.exec(mbuild.getCodeRef(), env2, memento);
        return res;
    }

    private void compileArgsBind(Datum bcdr, Environment env, CompiledCode.Builder builder, Cons symcall, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        ArrayList<Datum> vals;
        block6: {
            Datum prms = symcall.getCdr();
            vals = new ArrayList<Datum>();
            while (true) {
                if (prms == Nil.NIL) {
                    if (bcdr != Nil.NIL) {
                        throw this.message.getError("err.parameter.insufficient");
                    }
                    break block6;
                }
                if (prms instanceof Atom) {
                    this.compile(bcdr, env, builder, symcall, false, symlist, exec, memento, syncased);
                    builder.addBind(prms);
                    break block6;
                }
                if (!(bcdr instanceof Cons)) {
                    throw this.message.getError("err.parameter.insufficient");
                }
                if (!(prms instanceof Cons)) break;
                Datum a1 = ((Cons)prms).getCar();
                Datum a2 = ((Cons)bcdr).getCar();
                this.compile(a2, env, builder, symcall, false, symlist, exec, memento, syncased);
                vals.add(a1);
                prms = ((Cons)prms).getCdr();
                bcdr = ((Cons)bcdr).getCdr();
            }
            throw this.message.getError("err.type.invalid");
        }
        int i = vals.size() - 1;
        while (i >= 0) {
            builder.addBind((Datum)vals.get(i));
            --i;
        }
    }

    private void compileSexp(Datum bcar, Datum bcdr, Environment env, CompiledCode.Builder builder, Cons symcall, boolean istail, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (istail && bcar.equals(symcall.getCar())) {
            this.compileArgsBind(bcdr, env, builder, symcall, symlist, exec, memento, syncased);
            builder.addJmpTop();
        } else {
            this.compile(bcar, env, builder, false, symcall, false, symlist, exec, memento, syncased);
            this.compileArgs(bcdr, env, builder, symcall, symlist, exec, memento, syncased);
            if (istail) {
                builder.addCallTail(symlist.size());
            } else {
                builder.addCall();
            }
        }
    }

    @Override
    public void compileArgs(Datum bcdr, Environment env, CompiledCode.Builder builder, Cons symcall, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        block3: {
            builder.addBeginList();
            while (true) {
                if (bcdr instanceof Nil) {
                    builder.addEndList();
                    break block3;
                }
                if (bcdr instanceof Atom) {
                    this.compile(bcdr, env, builder, symcall, false, symlist, exec, memento, syncased);
                    builder.addEndListDot();
                    break block3;
                }
                if (!(bcdr instanceof Cons)) break;
                this.compile(((Cons)bcdr).getCar(), env, builder, symcall, false, symlist, exec, memento, syncased);
                builder.addAppendList();
                bcdr = ((Cons)bcdr).getCdr();
            }
            throw this.message.getError("err.type.invalid");
        }
    }

    private Datum getSym(Datum bcar, Environment env) {
        Datum ddd;
        if (bcar instanceof Symbol) {
            ddd = env.findDatum((Symbol)bcar);
        } else {
            SymbolScope ss = (SymbolScope)bcar;
            Environment menv = ss.getUserSyntax().getCompileEnv();
            ddd = menv.findDatum(ss.getSymbol());
        }
        return ddd;
    }

    private UserSyntax getUSyn(Datum d4, Environment env) {
        if (!(d4 instanceof SymbolName)) {
            return null;
        }
        Datum d5 = this.getSym(d4, env);
        if (d5 instanceof UserSyntax) {
            return (UserSyntax)d5;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void compile(Datum body, Environment env, CompiledCode.Builder builder, boolean toplevel, Cons symcall, boolean istail, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (body instanceof SymbolName) {
            Datum ddd = this.getSym(body, env);
            if (ddd instanceof UserSyntax) {
                UserSyntax sn = (UserSyntax)ddd;
                LispCompiler.MiscInfo mif = syncased;
                if (sn.getLambda() == null) {
                    builder.addReferSymbol(body);
                    return;
                } else {
                    Datum e2;
                    Datum exp = e2 = this.expandLambda(sn, body, env, exec, memento);
                    if (mif.getUserSyntax() == null) {
                        mif = new LispCompiler.MiscInfo(sn);
                    }
                    this.compile(exp, env, builder, toplevel, symcall, istail, symlist, exec, memento, mif);
                }
                return;
            } else {
                builder.addReferSymbol(body);
            }
            return;
        } else if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            if (bcar instanceof Symbol || bcar instanceof SymbolScope) {
                Datum ddd = this.getSym(bcar, env);
                if (ddd instanceof SynSetS) {
                    if (!(bcdr instanceof Cons)) throw this.message.getError("err.set.malform");
                    Datum d4 = ((Cons)bcdr).getCar();
                    UserSyntax sn = this.getUSyn(d4, env);
                    if (sn == null) {
                        Syntax syn = (Syntax)ddd;
                        Datum dz = bcdr;
                        syn.compile(dz, env, this, builder, toplevel, symcall, istail, this.message, symlist, exec, memento, syncased);
                        return;
                    } else {
                        Datum e2;
                        LispCompiler.MiscInfo mif = syncased;
                        if (sn.getLambda() == null) {
                            throw this.message.getError("err.set.malform");
                        }
                        Datum exp = e2 = this.expandLambda(sn, body, env, exec, memento);
                        if (mif.getUserSyntax() == null) {
                            mif = new LispCompiler.MiscInfo(sn);
                        }
                        this.compile(exp, env, builder, toplevel, symcall, istail, symlist, exec, memento, mif);
                    }
                    return;
                } else if (ddd instanceof Syntax) {
                    Syntax syn = (Syntax)ddd;
                    Datum dz = bcdr;
                    syn.compile(dz, env, this, builder, toplevel, symcall, istail, this.message, symlist, exec, memento, syncased);
                    return;
                } else if (ddd instanceof UserSyntax) {
                    Datum exp;
                    UserSyntax usyn = (UserSyntax)ddd;
                    Environment env2 = usyn.getCompileEnv();
                    LispCompiler.MiscInfo mif = syncased;
                    if (usyn.getLambda() == null) {
                        exp = this.expandSyntax(usyn, body, env2);
                    } else {
                        Datum e2;
                        exp = e2 = this.expandLambda(usyn, body, env, exec, memento);
                        if (mif.getUserSyntax() == null) {
                            mif = new LispCompiler.MiscInfo(usyn);
                        }
                        exp = AUX_S.call("letren", exp);
                    }
                    this.compile(exp, env, builder, toplevel, symcall, istail, symlist, exec, memento, mif);
                    return;
                } else if (ddd instanceof Macro) {
                    Datum exp = this.expandMacro(body, env, exec, memento);
                    this.compile(exp, env, builder, toplevel, symcall, istail, symlist, exec, memento, syncased);
                    return;
                } else {
                    this.compileSexp(bcar, bcdr, env, builder, symcall, istail, symlist, exec, memento, syncased);
                }
                return;
            } else if (bcar instanceof SynSyntax || bcar instanceof SynQuasisyntax) {
                Datum dz = ((Syntax)bcar).replaceLocalVals(((Cons)bcdr).getCar(), env, this, new Environment(), this.message, true, 1);
                ((Syntax)bcar).compile(dz, env, this, builder, toplevel, symcall, istail, this.message, symlist, exec, memento, syncased);
                return;
            } else {
                this.compileSexp(bcar, bcdr, env, builder, symcall, istail, symlist, exec, memento, syncased);
            }
            return;
        } else {
            builder.addPush(body);
        }
    }

    private Datum replaceLocalValsSexp(Datum bcar, Datum bcdr, Environment env, Environment ienv, int ttype) {
        Cons res = new Cons();
        res.setCar(this.replaceLocalVals(bcar, env, ienv, false, ttype));
        res.setCdr(this.replaceLocalValsArgs(bcdr, env, ienv, ttype));
        return res;
    }

    @Override
    Datum replaceLocalValsOnly(Datum body, Environment env, Environment ienv, boolean toplv, int ttype) {
        if (body instanceof SymbolName) {
            Symbol sym = ((SymbolName)((Object)body)).getSymbol();
            Datum d = ienv.findDatum(sym);
            return d != null ? d : body;
        }
        if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            Cons res = new Cons();
            res.setCar(this.replaceLocalValsOnly(bcar, env, ienv, toplv, ttype));
            res.setCdr(this.replaceLocalValsOnly(bcdr, env, ienv, toplv, ttype));
            return res;
        }
        return body;
    }

    private Datum replaceLocalValsWithSyn(Datum bcdr, Environment env, Environment ienv, int ttype) {
        ConsListBuilder res = new ConsListBuilder();
        ConsIterator itr = new ConsIterator(bcdr);
        ConsListBuilder re2 = new ConsListBuilder();
        if (!itr.hasNext()) {
            throw this.message.getError("err.withsyntax.malform");
        }
        res.append(itr.next());
        if (!itr.hasNext()) {
            throw this.message.getError("err.withsyntax.malform");
        }
        ConsIterator it2 = new ConsIterator(itr.next());
        while (it2.hasNext()) {
            ConsListBuilder re3 = new ConsListBuilder();
            ConsIterator it3 = new ConsIterator(it2.next());
            if (!it3.hasNext()) {
                throw this.message.getError("err.withsyntax.malform");
            }
            re3.append(it3.next());
            if (!it3.hasNext()) {
                throw this.message.getError("err.withsyntax.malform");
            }
            re3.append(this.replaceLocalValsOnly(it3.next(), env, ienv, false, ttype));
            if (it3.hasNext()) {
                throw this.message.getError("err.withsyntax.malform");
            }
            re2.append(re3.get());
        }
        res.append(re2.get());
        while (itr.hasNext()) {
            res.append(this.replaceLocalValsOnly(itr.next(), env, ienv, false, ttype));
        }
        return res.get();
    }

    @Override
    public Datum replaceLocalValsArgs(Datum bcdr, Environment env, Environment ienv, int ttype) {
        ArrayList<Datum> res = new ArrayList<Datum>();
        while (true) {
            if (bcdr instanceof Nil) {
                return LispUtils.listToCons(res);
            }
            if (bcdr instanceof Atom) {
                return LispUtils.listToCons(res, this.replaceLocalVals(bcdr, env, ienv, false, ttype));
            }
            if (!(bcdr instanceof Cons)) break;
            res.add(this.replaceLocalVals(((Cons)bcdr).getCar(), env, ienv, false, ttype));
            bcdr = ((Cons)bcdr).getCdr();
        }
        throw this.message.getError("err.type.invalid");
    }

    @Override
    public Datum replaceLocalVals(Datum body, Environment env, Environment ienv, boolean toplv, int ttype) {
        if (body instanceof SymbolName) {
            Symbol sym = ((SymbolName)((Object)body)).getSymbol();
            Datum d = ienv.findDatum(sym);
            return d != null ? d : body;
        }
        if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            if (bcar instanceof Symbol || bcar instanceof SymbolScope) {
                Symbol sym = ((SymbolName)((Object)bcar)).getSymbol();
                Datum d2 = this.getSym(bcar, env);
                if (d2 instanceof SynSetS) {
                    if (bcdr instanceof Cons) {
                        Datum d4 = ((Cons)bcdr).getCar();
                        UserSyntax sn = this.getUSyn(d4, env);
                        if (sn == null) {
                            Syntax syn = (Syntax)d2;
                            Cons res = new Cons();
                            res.setCar(bcar);
                            res.setCdr(syn.replaceLocalVals(bcdr, env, this, ienv, this.message, toplv, ttype));
                            return res;
                        }
                        if (sn.getLambda() == null) {
                            throw this.message.getError("err.set.malform");
                        }
                        Datum exp = body;
                        return exp;
                    }
                    throw this.message.getError("err.set.malform");
                }
                if (d2 instanceof Syntax) {
                    Syntax syn = (Syntax)d2;
                    Cons res = new Cons();
                    res.setCar(bcar);
                    res.setCdr(syn.replaceLocalVals(bcdr, env, this, ienv, this.message, toplv, ttype));
                    return res;
                }
                if (SynSyntax.WITH_SYNTAX.equals(sym)) {
                    return this.replaceLocalValsWithSyn(body, env, ienv, ttype);
                }
                if (d2 instanceof UserSyntax) {
                    UserSyntax usyn = (UserSyntax)d2;
                    Datum exp = usyn.getLambda() == null ? this.replaceLocalValsSexp(bcar, bcdr, env, ienv, ttype) : body;
                    return exp;
                }
                return this.replaceLocalValsSexp(bcar, bcdr, env, ienv, ttype);
            }
            return this.replaceLocalValsSexp(bcar, bcdr, env, ienv, ttype);
        }
        return body;
    }

    private D2 expandMacroSexp(Datum car, Datum cdr, Environment env, CodeExecutor exec, IntStack memento) {
        Cons res = new Cons();
        D2 d2 = this.expandMacro1i(car, env, exec, memento);
        res.setCar(d2.d);
        boolean dirty = d2.dirty;
        ArrayList<Datum> lst = new ArrayList<Datum>();
        while (cdr instanceof Cons) {
            Cons c = (Cons)cdr;
            D2 d3 = this.expandMacro1i(c.getCar(), env, exec, memento);
            lst.add(d3.d);
            dirty = d3.dirty || dirty;
            cdr = c.getCdr();
        }
        if (cdr == Nil.NIL) {
            res.setCdr(LispUtils.listToCons(lst));
            return new D2(res, dirty);
        }
        res.setCdr(LispUtils.listToCons(lst, cdr));
        return new D2(res, dirty);
    }

    private D2 expandMacro1i(Datum body, Environment env, CodeExecutor exec, IntStack memento) {
        D2 res = new D2();
        if (body instanceof Cons) {
            Cons c = (Cons)body;
            if (c.getCar() instanceof SymbolName) {
                Datum d = env.findDatum(((SymbolName)((Object)c.getCar())).getSymbol());
                if (d instanceof MacroDefinition) {
                    return new D2(body, false);
                }
                if (d instanceof Macro) {
                    Macro m = (Macro)d;
                    Closure cl = m.getClosure();
                    Environment nenv = new Environment(env);
                    IntLispUtils.bindLocal(cl.getParameterList(), c.getCdr(), nenv, this.message);
                    res.d = exec.exec(cl.getCode(), nenv, memento);
                    res.dirty = true;
                    return res;
                }
                if (d instanceof SynQuote) {
                    res.d = body;
                    res.dirty = false;
                    return res;
                }
                return this.expandMacroSexp(c.getCar(), c.getCdr(), env, exec, memento);
            }
            return this.expandMacroSexp(c.getCar(), c.getCdr(), env, exec, memento);
        }
        res.d = body;
        res.dirty = false;
        return res;
    }

    @Override
    public Datum expandMacro1(Datum body, Environment env, CodeExecutor exec, IntStack memento) {
        return this.expandMacro1i(body, env, exec, memento).d;
    }

    @Override
    public Datum expandMacro(Datum body, Environment env, CodeExecutor exec, IntStack memento) {
        Datum b;
        D2 loop = new D2(body, false);
        do {
            Datum d1;
            Datum c1;
            if (!((b = loop.d) instanceof Cons) || !((c1 = ((Cons)b).getCar()) instanceof Symbol ? env.findDatum(c1) instanceof MacroDefinition : c1 instanceof SymbolScope && (d1 = env.findDatum(((SymbolScope)c1).getSymbol())) instanceof SynDefineMacro)) continue;
            return b;
        } while ((loop = this.expandMacro1i(b, env, exec, memento)).dirty);
        return loop.d;
    }

    private class D2 {
        private Datum d;
        private boolean dirty;

        private D2() {
        }

        private D2(Datum d, boolean dirty) {
            this.d = d;
            this.dirty = dirty;
        }
    }

    private static class EqWithSyn
    extends BinaryArgs {
        private EqWithSyn() {
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolScope && c2a instanceof SymbolScope) {
                SymbolScope s1 = (SymbolScope)c1a;
                SymbolScope s2 = (SymbolScope)c2a;
                return LispBoolean.getInstance(s1.getSymbol().equals(s2.getSymbol()) && s1.isSameScope(s2));
            }
            return LispBoolean.FALSE;
        }
    }

    private static class RmWithSyn
    extends UnaryArgs {
        private RmWithSyn() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof SymbolScope) {
                SymbolScope s1 = (SymbolScope)c1a;
                return s1.getSymbol();
            }
            return c1a;
        }
    }
}

