/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalRingElement;

public abstract class AbstractNumerical<E extends NumericalRingElement<E>>
implements NumericalRingElement<E> {
    private static final Integer2 _I_MAX = Integer2.valueOf(Integer.MAX_VALUE);
    private static final Integer2 _I_MIN = Integer2.valueOf(Integer.MIN_VALUE);
    private static final Integer2 _S_MAX = Integer2.valueOf(Short.MAX_VALUE);
    private static final Integer2 _S_MIN = Integer2.valueOf(Short.MIN_VALUE);
    private static final Integer2 _B_MAX = Integer2.valueOf(127);
    private static final Integer2 _B_MIN = Integer2.valueOf(-128);
    private static final Integer2 _L_MAX = Integer2.valueOf(Long.MAX_VALUE);
    private static final Integer2 _L_MIN = Integer2.valueOf(Long.MIN_VALUE);

    @Override
    public byte byteFloor() {
        return (byte)this.intFloor();
    }

    @Override
    public short shortFloor() {
        return (short)this.intFloor();
    }

    @Override
    public byte byteCeil() {
        return (byte)this.intCeil();
    }

    @Override
    public short shortCeil() {
        return (short)this.intCeil();
    }

    @Override
    public boolean inByteRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_B_MAX) <= 0 && f.compareTo(_B_MIN) >= 0;
    }

    @Override
    public boolean inShortRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_S_MAX) <= 0 && f.compareTo(_S_MIN) >= 0;
    }

    @Override
    public boolean inIntRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_I_MAX) <= 0 && f.compareTo(_I_MIN) >= 0;
    }

    @Override
    public boolean inLongRange() {
        Integer2 f = this.getInteger2Floor();
        Integer2 c = this.getInteger2Ceil();
        return c.compareTo(_L_MAX) <= 0 && f.compareTo(_L_MIN) >= 0;
    }
}

