/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFA;
import net.morilib.automata.nfa.NFAConcatenation;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAState;
import net.morilib.automata.nfa.SingleObjectNFA;
import net.morilib.range.Range;
import net.morilib.util.LinkedListStack;

public final class NFAs {
    private NFAs() {
    }

    public static <A, B> NFA<Integer, A, B> build(String str) {
        ArrayList arr = new ArrayList();
        int i = 0;
        while (i < str.length()) {
            arr.add(SingleObjectNFA.newInstance(new Integer(str.charAt(i))));
            ++i;
        }
        return NFAConcatenation.newInstance(arr);
    }

    public static <T, A, B> NFA<T, A, B> build(T[] array) {
        ArrayList arr = new ArrayList();
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            arr.add(SingleObjectNFA.newInstance(t));
            ++n2;
        }
        return NFAConcatenation.newInstance(arr);
    }

    public static <T, A, B> NFA<T, A, B> build(Collection<T> col) {
        ArrayList arr = new ArrayList();
        for (T t : col) {
            arr.add(SingleObjectNFA.newInstance(t));
        }
        return NFAConcatenation.newInstance(arr);
    }

    public static <T, A, B> Set<NFAState> getEpsilonReachable(NFA<T, A, B> nfa, Set<NFAState> states) {
        HashSet<NFAState> res = new HashSet<NFAState>(states);
        LinkedListStack<NFAState> stk = new LinkedListStack<NFAState>(states);
        while (!stk.isEmpty()) {
            NFAState t = (NFAState)stk.pop();
            Set<NFAState> e = nfa.getStatesEpsilon(t);
            for (NFAState u : e) {
                if (res.contains(u)) continue;
                res.add(u);
                stk.push(u);
            }
        }
        return res;
    }

    public static <T, A, B> Set<B> getMatchTag(NFA<T, A, B> nfa, Set<NFAState> states) {
        HashSet<B> res = new HashSet<B>();
        for (NFAState s : states) {
            res.addAll(nfa.getMatchTag(s));
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A, B> Set<B> getMatchTagEnd(NFA<T, A, B> nfa, Set<NFAState> states) {
        HashSet<B> res = new HashSet<B>();
        for (NFAState s : states) {
            res.addAll(nfa.getMatchTagEnd(s));
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A, B> Set<A> getAccept(NFA<T, A, B> nfa, Set<NFAState> states) {
        HashSet<A> res = new HashSet<A>();
        for (NFAState s : states) {
            res.addAll(nfa.getAccept(s));
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A, B> Set<NFAState> getStates(NFA<T, A, B> nfa, Set<NFAState> state, T alphabet) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        if (nfa instanceof NFAObject) {
            NFAObject nfo = (NFAObject)nfa;
            for (NFAState s : state) {
                nfo.addStates(res, s, alphabet);
            }
        } else {
            for (NFAState s : state) {
                res.addAll(nfa.getStates(s, alphabet));
            }
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A, B> Set<NFAState> getStates(NFA<T, A, B> nfa, Set<NFAState> state, Range rng) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        if (nfa instanceof NFAObject) {
            NFAObject nfo = (NFAObject)nfa;
            for (NFAState s : state) {
                nfo.addStates((Set<NFAState>)res, s, rng);
            }
        } else {
            for (NFAState s : state) {
                res.addAll(nfa.getStates(s, rng));
            }
        }
        return Collections.unmodifiableSet(res);
    }

    public static <T, A, B> Set<NFAState> getStatesBound(NFA<T, A, B> nfa, Set<NFAState> state, EnumSet<TextBound> b) {
        HashSet<NFAState> res = new HashSet<NFAState>();
        if (nfa instanceof NFAObject) {
            NFAObject nfo = (NFAObject)nfa;
            for (NFAState s : state) {
                nfo.addStatesBound(res, s, b);
            }
        } else {
            for (NFAState s : state) {
                res.addAll(nfa.getStates(s, b));
            }
        }
        return Collections.unmodifiableSet(res);
    }
}

