/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.sss.servlet.http;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.OutputPort;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/02/19
 */
public class LispHttpResponse extends Datum {

	//
	/*package*/ HttpServletResponse resp;

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2011/02/19
	 */
	public static class SetContentType extends BinaryArgs {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
		 */
		@Override
		protected Datum execute(
				Datum c1a, Datum c2a, Environment env,
				LispMessage mesg) {
			if(!(c1a instanceof LispHttpResponse)) {
				throw mesg.getError(
						"err.sss.require.httpresponse", c1a);
			} else if(!(c2a instanceof LispString)) {
				throw mesg.getError("err.require.string", c2a);
			}

			((LispHttpResponse)c1a).resp.setContentType(
					c2a.getString());
			return Undef.UNDEF;
		}

	}

	
	public static class GetOutputPort extends UnaryArgs {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.subr.UnaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
		 */
		@Override
		protected Datum execute(
				Datum c1a, Environment env, LispMessage mesg) {
			if(c1a instanceof LispHttpResponse) {
				try {
					return new OutputPort(
							((LispHttpResponse)c1a).resp.getWriter(),
							mesg);
				} catch (IOException e) {
					throw mesg.getError("err.io");
				}
			} else {
				throw mesg.getError(
						"err.sss.require.httpresponse", c1a);
			}
		}

	}

	/**
	 * @param resp
	 */
	/*package*/ LispHttpResponse(HttpServletResponse resp) {
		this.resp = resp;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#toDisplayString(java.lang.StringBuilder)
	 */
	@Override
	public void toDisplayString(StringBuilder buf) {
		buf.append("#<http-response>");
	}

}
