/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.sss.servlet.http;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.TernaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/02/19
 */
public class Include extends TernaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.TernaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(
			Datum c1a, Datum c2a, Datum c3a, Environment env,
			LispMessage mesg) {
		RequestDispatcher rd;
		HttpServletRequest req;
		HttpServletResponse resp;

		if(!(c1a instanceof LispString)) {
			throw mesg.getError("err.require.string", c1a);
		} else if(!(c2a instanceof LispHttpRequest)) {
			throw mesg.getError("err.sss.require.httprequest", c2a);
		} else if(!(c3a instanceof LispHttpResponse)) {
			throw mesg.getError("err.sss.require.httprequest", c3a);
		}

		req  = ((LispHttpRequest)c2a).req;
		resp = ((LispHttpResponse)c3a).resp;
		rd   = req.getRequestDispatcher(c1a.getString());
		if(rd == null) {
			throw mesg.getError("err.sss.requestdispatcher", c1a);
		}

		try {
			rd.include(req, resp);
		} catch (ServletException e) {
			throw mesg.getError("err.sss.servlet", e);
		} catch (IOException e) {
			throw mesg.getError("err.io", e);
		}
		return Undef.UNDEF;
	}

}
