/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

import java.io.Closeable;
import java.io.IOException;

/**
 * An utility class for I/O.
 * <p>I/Oのためのユーティリティクラスである。
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2010/04/18
 */
public final class IOs {
	
	private IOs() {}
	
	/**
	 * close the given Closeable quietly.
	 * <p>与えられたCloseableを例外をキャッチせずに閉じます。
	 * 
	 * @param ins Closeable to be closed
	 */
	public static void close(Closeable ins) {
		if(ins != null) {
			try {
				ins.close();
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
	}
	
}
