/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import net.morilib.util.Arrays2;
import net.morilib.util.Bytes;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.Endianness;
import net.morilib.util.uvector.UniformArray;

public class ShortArray
extends AbstractUniformArray {
    private short[] array;
    private UniformArray.TypeAttr signed;

    private ShortArray(short[] arr, UniformArray.TypeAttr attr) {
        if (!attr.isExact()) {
            throw new IllegalArgumentException(attr.toString());
        }
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = new short[arr.length];
        this.signed = attr;
        System.arraycopy(arr, 0, this.array, 0, arr.length);
    }

    public ShortArray(ShortArray a) {
        this.array = Arrays2.copy(a.array);
        this.signed = a.signed;
    }

    public static ShortArray newArray(short[] arr) {
        return new ShortArray(arr, UniformArray.TypeAttr.SIGNED_INT);
    }

    public static ShortArray newuArray(short[] arr) {
        return new ShortArray(arr, UniformArray.TypeAttr.UNSIGNED_INT);
    }

    @Override
    public byte getByte(int i) {
        short r = this.getShort(i);
        return (byte)r;
    }

    @Override
    public double getDouble(int i) {
        return this.getInt(i);
    }

    @Override
    public float getFloat(int i) {
        return this.getInt(i);
    }

    @Override
    public int getInt(int i) {
        int r = this.getShort(i);
        return this.signed.isSigned() ? r : Bytes.ushortToInt((short)r);
    }

    @Override
    public long getLong(int i) {
        short r = this.getShort(i);
        return this.signed.isSigned() ? (long)r : Bytes.ushortToLong(r);
    }

    @Override
    public short getShort(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    @Override
    public void setByte(int i, byte x) {
        this.setShort(i, this.signed.isSigned() ? x : Bytes.ubyteToShort((byte)x));
    }

    @Override
    public void setDouble(int i, double x) {
        this.setLong(i, (long)x);
    }

    @Override
    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    @Override
    public void setInt(int i, int x) {
        this.setShort(i, (short)x);
    }

    @Override
    public void setLong(int i, long x) {
        this.setShort(i, (short)x);
    }

    @Override
    public void setShort(int i, short x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public byte[] toByteArray(Endianness e) {
        byte[] res = new byte[this.array.length << 1];
        int i = 0;
        while (i < this.array.length) {
            e.writeShort(res, i << 1, this.array[i]);
            ++i;
        }
        return res;
    }

    public short[] toArray() {
        return Arrays2.copy(this.array);
    }
}

