/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import net.morilib.util.Iterators;
import net.morilib.util.Objects;

public final class Sets {
    private static SortedSet<Object> EMPTY = new EmptySSet();

    private Sets() {
    }

    public static <T> SortedSet<T> emptySortedSet() {
        return EMPTY;
    }

    public static <E> Set<E> unmodifiable(Set<E> wrapee) {
        return wrapee == null ? null : Collections.unmodifiableSet(wrapee);
    }

    public static <E> SortedSet<E> sortedUnmodifiable(SortedSet<E> wrapee) {
        return wrapee == null ? null : new Unmodify1<E>(wrapee);
    }

    public static <E> SortedSet<E> sortedSingleton(E o) {
        return new Singleton<E>(o, null);
    }

    public static <E> SortedSet<E> sortedSingleton(E o, Comparator<E> comp) {
        return new Singleton<E>(o, comp);
    }

    public static <E> boolean isIndependent(Set<E> a, Set<E> b) {
        int diff = a.size() - b.size();
        Set<E> l = diff > 0 ? a : b;
        Set<E> s = diff > 0 ? b : a;
        for (E o : s) {
            if (!l.contains(o)) continue;
            return false;
        }
        return true;
    }

    public static class EmptySSet
    implements SortedSet<Object> {
        @Override
        public Object first() {
            throw new NoSuchElementException();
        }

        @Override
        public Object last() {
            throw new NoSuchElementException();
        }

        @Override
        public Comparator<Object> comparator() {
            return null;
        }

        @Override
        public SortedSet<Object> headSet(Object toElement) {
            return this;
        }

        @Override
        public SortedSet<Object> tailSet(Object fromElement) {
            return this;
        }

        @Override
        public SortedSet<Object> subSet(Object fromElement, Object toElement) {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Object[] toArray() {
            return Objects.OBJECT_EMPTY;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof SortedSet) {
                return ((Collection)o).isEmpty();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "[]";
        }
    }

    private static class Singleton<E>
    implements SortedSet<E> {
        private E value;
        private Comparator<E> comp;

        Singleton(E o, Comparator<E> c) {
            this.value = o;
            this.comp = c;
        }

        @Override
        public E first() {
            return this.value;
        }

        @Override
        public E last() {
            return this.value;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.comp;
        }

        @Override
        public SortedSet<E> headSet(E e) {
            return Objects.compare(this.value, e, this.comp) <= 0 ? this : EMPTY;
        }

        @Override
        public SortedSet<E> tailSet(E e) {
            return Objects.compare(this.value, e, this.comp) >= 0 ? this : EMPTY;
        }

        @Override
        public SortedSet<E> subSet(E from, E to) {
            return Objects.between(this.value, from, to, this.comp) ? this : EMPTY;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.value};
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return Objects.equals(this.value, o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty() || c.size() == 1 && c.contains(this.value);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.singleton(this.value);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            try {
                a[0] = this.value;
            }
            catch (ClassCastException e) {
                throw new ArrayStoreException();
            }
            return a;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Collection) {
                Collection s = (Collection)o;
                return s.size() == 1 && s.contains(this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 37 * (this.value.hashCode() + 17);
        }

        public String toString() {
            return "[" + this.value.toString() + "]";
        }
    }

    private static class Unmodify1<E>
    implements SortedSet<E> {
        SortedSet<E> wrapee;

        Unmodify1(SortedSet<E> w) {
            this.wrapee = w;
        }

        @Override
        public E first() {
            return this.wrapee.first();
        }

        @Override
        public E last() {
            return this.wrapee.last();
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.wrapee.comparator();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.wrapee.headSet(toElement);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.wrapee.tailSet(fromElement);
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new Unmodify1<E>(this.wrapee.subSet(fromElement, toElement));
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return this.wrapee.toArray();
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.wrapee.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.wrapee.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiable(this.wrapee.iterator());
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.wrapee.toArray(a);
        }

        @Override
        public boolean equals(Object o) {
            return this.wrapee.equals(o);
        }

        @Override
        public int hashCode() {
            return this.wrapee.hashCode();
        }

        public String toString() {
            return this.wrapee.toString();
        }
    }
}

