/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.r6rs.LibraryIDException;
import net.morilib.lisp.r6rs.SymbolEnv;

public class LibraryID {
    private static Map<LibraryID, Environment> namespc = new HashMap<LibraryID, Environment>();
    private static Map<LibraryID, Map<Symbol, Symbol>> exports = new HashMap<LibraryID, Map<Symbol, Symbol>>();
    private Cons id;
    private static final Symbol LIBRARY = Symbol.getSymbol("library");
    private static final Symbol ONLY = Symbol.getSymbol("only");
    private static final Symbol EXCEPT = Symbol.getSymbol("except");
    private static final Symbol PREFIX = Symbol.getSymbol("prefix");
    private static final Symbol RENAME = Symbol.getSymbol("rename");

    public LibraryID(Datum dtm) {
        if (dtm == null) {
            throw new NullPointerException();
        }
        if (!(dtm instanceof Cons)) {
            throw new IllegalArgumentException();
        }
        this.id = (Cons)dtm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Environment getNamespace(LibraryID id) {
        Class<LibraryID> clazz = LibraryID.class;
        synchronized (LibraryID.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return namespc.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Symbol, Symbol> getExport(LibraryID id) {
        Class<LibraryID> clazz = LibraryID.class;
        synchronized (LibraryID.class) {
            Map<Symbol, Symbol> res = exports.get(id);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return res != null ? Collections.unmodifiableMap(res) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putNamespace(LibraryID id, Environment sp, Map<Symbol, Symbol> ex) {
        Class<LibraryID> clazz = LibraryID.class;
        synchronized (LibraryID.class) {
            namespc.put(id, sp);
            exports.put(id, new HashMap<Symbol, Symbol>(ex));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static LibraryIDException getError(String s) {
        return new LibraryIDException(s);
    }

    private static LibraryIDException getError(String s, Datum d) {
        return new LibraryIDException(s, d);
    }

    private static Datum car(Datum b) throws LibraryIDException {
        if (!(b instanceof Cons)) {
            throw LibraryID.getError("err.import.malform");
        }
        Cons c0 = (Cons)b;
        return c0.getCar();
    }

    private static Cons cxdr(Datum b) throws LibraryIDException {
        if (!(b instanceof Cons)) {
            throw LibraryID.getError("err.import.malform");
        }
        Cons c0 = (Cons)b;
        if (!(c0.getCdr() instanceof Cons)) {
            throw LibraryID.getError("err.import.malform");
        }
        return (Cons)c0.getCdr();
    }

    private static Datum cadr(Datum b) throws LibraryIDException {
        return LibraryID.cxdr(b).getCar();
    }

    private static Datum cddr(Datum b) throws LibraryIDException {
        return LibraryID.cxdr(b).getCdr();
    }

    private static Symbol findkey(Map<Symbol, SymbolEnv> sym, Symbol s) {
        for (Map.Entry<Symbol, SymbolEnv> e : sym.entrySet()) {
            if (!e.getValue().getSymbol().equals(s)) continue;
            return e.getKey();
        }
        return null;
    }

    private static void putenv(LibraryID id, Map<Symbol, SymbolEnv> sym) throws LibraryIDException {
        Map<Symbol, Symbol> mp = LibraryID.getExport(id);
        Environment env = LibraryID.getNamespace(id);
        if (mp == null) {
            throw LibraryID.getError("err.library.undefined");
        }
        for (Map.Entry<Symbol, Symbol> e : mp.entrySet()) {
            sym.put(e.getKey(), new SymbolEnv(e.getValue(), env));
        }
    }

    private static Map<Symbol, SymbolEnv> only(Map<Symbol, SymbolEnv> sym, Datum lst) throws LibraryIDException {
        ConsIterator itr = new ConsIterator(lst);
        HashMap<Symbol, SymbolEnv> res = new HashMap<Symbol, SymbolEnv>();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!(d instanceof Symbol)) {
                throw LibraryID.getError("err.require.symbol", d);
            }
            Symbol e = LibraryID.findkey(sym, (Symbol)d);
            if (e == null) {
                throw LibraryID.getError("err.library.undefined");
            }
            res.put(e, sym.get(e));
        }
        if (itr.getTerminal() != Nil.NIL) {
            throw LibraryID.getError("err.list");
        }
        return res;
    }

    private static Map<Symbol, SymbolEnv> except(Map<Symbol, SymbolEnv> sym, Datum lst) throws LibraryIDException {
        ConsIterator itr = new ConsIterator(lst);
        Map<Symbol, SymbolEnv> res = sym;
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!(d instanceof Symbol)) {
                throw LibraryID.getError("err.require.symbol", d);
            }
            Symbol e = LibraryID.findkey(sym, (Symbol)d);
            if (e == null) {
                throw LibraryID.getError("err.library.undefined");
            }
            res.remove(e);
        }
        if (itr.getTerminal() != Nil.NIL) {
            throw LibraryID.getError("err.list");
        }
        return res;
    }

    private static Map<Symbol, SymbolEnv> prefix(Map<Symbol, SymbolEnv> sym, Datum lst) throws LibraryIDException {
        ConsIterator itr = new ConsIterator(lst);
        Map<Symbol, SymbolEnv> res = sym;
        if (!itr.hasNext()) {
            throw LibraryID.getError("err.import.malform");
        }
        Datum d = itr.next();
        if (!(d instanceof Symbol)) {
            throw LibraryID.getError("err.require.symbol", d);
        }
        if (itr.hasNext()) {
            throw LibraryID.getError("err.import.malform");
        }
        if (itr.getTerminal() != Nil.NIL) {
            throw LibraryID.getError("err.list");
        }
        for (Map.Entry<Symbol, SymbolEnv> e : sym.entrySet()) {
            String sn = ((Symbol)d).getName();
            Symbol s2 = Symbol.getSymbol(String.valueOf(sn) + e.getValue().getSymbol().getName());
            e.setValue(e.getValue().prototype(s2));
        }
        return res;
    }

    private static Map<Symbol, SymbolEnv> rename(Map<Symbol, SymbolEnv> sym, Datum lst) throws LibraryIDException {
        ConsIterator itr = new ConsIterator(lst);
        Map<Symbol, SymbolEnv> res = sym;
        while (itr.hasNext()) {
            Datum d = itr.next();
            Datum da = LibraryID.car(d);
            Datum dd = LibraryID.cadr(d);
            if (LibraryID.cddr(d) != Nil.NIL) {
                throw LibraryID.getError("err.import.malform");
            }
            Symbol e = LibraryID.findkey(sym, (Symbol)da);
            if (e == null) {
                throw LibraryID.getError("err.library.undefined");
            }
            res.put(e, res.get(e).prototype((Symbol)dd));
        }
        if (itr.getTerminal() != Nil.NIL) {
            throw LibraryID.getError("err.list");
        }
        return res;
    }

    private static Map<Symbol, SymbolEnv> compileImportSet(Datum d) throws LibraryIDException {
        return LibraryID.compileImportSet0(d, new HashMap<Symbol, SymbolEnv>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Symbol, SymbolEnv> compileImportSet0(Datum d, Map<Symbol, SymbolEnv> res) throws LibraryIDException {
        if (!(d instanceof Cons)) throw LibraryID.getError("err.libid");
        Cons c0 = (Cons)d;
        if (c0.getCar().equals(LIBRARY)) {
            LibraryID.putenv(new LibraryID(LibraryID.cadr(c0)), res);
            return res;
        } else if (c0.getCar().equals(ONLY)) {
            Map<Symbol, SymbolEnv> r2 = LibraryID.only(LibraryID.compileImportSet(LibraryID.cadr(c0)), LibraryID.cddr(c0));
            res.putAll(r2);
            return res;
        } else if (c0.getCar().equals(EXCEPT)) {
            Map<Symbol, SymbolEnv> r2 = LibraryID.except(LibraryID.compileImportSet(LibraryID.cadr(c0)), LibraryID.cddr(c0));
            res.putAll(r2);
            return res;
        } else if (c0.getCar().equals(PREFIX)) {
            Map<Symbol, SymbolEnv> r2 = LibraryID.prefix(LibraryID.compileImportSet(LibraryID.cadr(c0)), LibraryID.cddr(c0));
            res.putAll(r2);
            return res;
        } else if (c0.getCar().equals(RENAME)) {
            Map<Symbol, SymbolEnv> r2 = LibraryID.rename(LibraryID.compileImportSet(LibraryID.cadr(c0)), LibraryID.cddr(c0));
            res.putAll(r2);
            return res;
        } else {
            if (!(c0.getCar() instanceof Symbol)) throw LibraryID.getError("err.libid");
            LibraryID.putenv(new LibraryID(c0), res);
        }
        return res;
    }

    public static Map<Symbol, SymbolEnv> compileImport(Datum body) throws LibraryIDException {
        ConsIterator itr = new ConsIterator(body);
        HashMap<Symbol, SymbolEnv> res = new HashMap<Symbol, SymbolEnv>();
        while (itr.hasNext()) {
            Datum d = itr.next();
            LibraryID.compileImportSet0(d, res);
        }
        if (itr.getTerminal() != Nil.NIL) {
            throw LibraryID.getError("err.list");
        }
        return Collections.unmodifiableMap(res);
    }

    public boolean equals(Object o) {
        if (o instanceof LibraryID) {
            return this.id.getCar().equals(((LibraryID)o).id.getCar());
        }
        return false;
    }

    public int hashCode() {
        return this.id.getCar().hashCode();
    }
}

