/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter.drawer;

import net.morilib.lisp.painter.geom.Point2D;

public class CoordinateMap {
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public CoordinateMap(double x1, double y1, double x2, double y2) {
        if (x2 <= x1) {
            throw new IllegalArgumentException();
        }
        if (y2 <= y1) {
            throw new IllegalArgumentException();
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public Point2D transform(int framex, int framey, double x, double y) {
        double xt = (x - this.x1) / (this.x2 - this.x1);
        double yt = (y - this.y1) / (this.y2 - this.y1);
        return new Point2D((double)framex * xt, (double)framey * (1.0 - yt));
    }

    public Point2D transformSize(int framex, int framey, double x, double y) {
        double xt = x / (this.x2 - this.x1);
        double yt = y / (this.y2 - this.y1);
        return new Point2D((double)framex * xt, (double)framey * yt);
    }

    public Point2D invertSize(int framex, int framey, double xt, double yt) {
        double x = xt / (double)framex * (this.x2 - this.x1);
        double y = yt / (double)framey * (this.y2 - this.y1);
        return new Point2D(x, y);
    }
}

