/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.morilib.lisp.Datum;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.painter.geom.Point2D;

public class SchlushWindowFrame
extends Datum
implements SchlushFrame {
    JFrame frame;
    private List<SchlushFrame.ImageInfo> images = new ArrayList<SchlushFrame.ImageInfo>();
    private List<Drawer> drawers = new ArrayList<Drawer>();
    private CoordinateMap coordinate;
    private boolean disposed = false;

    public SchlushWindowFrame(int x, int y, CoordinateMap coordinate) {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(x, y);
        this.frame.add(new SFrame());
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                SchlushWindowFrame.this.disposed = true;
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.coordinate = coordinate;
    }

    public SchlushWindowFrame(int x, int y) {
        this(x, y, null);
    }

    private void loadImage(Image img) throws InterruptedException {
        MediaTracker mt = new MediaTracker(this.frame);
        mt.addImage(img, 1);
        mt.waitForAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addImage(SchlushFrame.ImageInfo img) throws InterruptedException {
        Image img2 = null;
        if (this.disposed) {
            return;
        }
        if (this.coordinate != null) {
            Point2D ps = this.coordinate.transformSize(this.frame.getWidth(), this.frame.getHeight(), img.sx, img.sy);
            if (ps.getXInt() > 0 && ps.getYInt() > 0) {
                img2 = img.img.getScaledInstance(ps.getXInt(), ps.getYInt(), 4);
            }
        } else if ((int)img.sx > 0 && (int)img.sy > 0) {
            img2 = img.img.getScaledInstance((int)img.sx, (int)img.sy, 4);
        }
        if (img2 != null) {
            this.loadImage(img.img);
            List<SchlushFrame.ImageInfo> list = this.images;
            synchronized (list) {
                this.images.add(new SchlushFrame.ImageInfo(img2, img.x, img.y, img.sx, img.sy));
            }
            this.frame.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDrawer(Drawer drawer) {
        if (this.disposed) {
            return;
        }
        List<Drawer> list = this.drawers;
        synchronized (list) {
            this.drawers.add(drawer);
        }
        this.frame.repaint();
    }

    @Override
    public int getImageWidth(Image img) {
        return img.getWidth(this.frame);
    }

    @Override
    public int getImageHeight(Image img) {
        return img.getHeight(this.frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScreen() {
        if (this.disposed) {
            return;
        }
        List<Object> list = this.images;
        synchronized (list) {
            this.images.clear();
        }
        list = this.drawers;
        synchronized (list) {
            this.drawers.clear();
        }
        this.frame.repaint();
    }

    @Override
    public CoordinateMap getCoordinate() {
        return this.coordinate;
    }

    @Override
    public int getHeight() {
        return this.frame.getHeight();
    }

    @Override
    public int getWidth() {
        return this.frame.getWidth();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<window-frame>");
    }

    private class SFrame
    extends JPanel {
        private static final long serialVersionUID = 8388728689806126886L;

        private SFrame() {
        }

        private void paintImage(Graphics g, SchlushFrame.ImageInfo info) {
            if (SchlushWindowFrame.this.coordinate != null) {
                Point2D p0 = SchlushWindowFrame.this.coordinate.transform(SchlushWindowFrame.this.frame.getWidth(), SchlushWindowFrame.this.frame.getHeight(), info.x, info.y);
                Point2D ps = SchlushWindowFrame.this.coordinate.transformSize(SchlushWindowFrame.this.frame.getWidth(), SchlushWindowFrame.this.frame.getHeight(), info.sx, info.sy);
                g.drawImage(info.img, p0.getXInt(), p0.getYInt() - ps.getYInt(), this);
            } else {
                g.drawImage(info.img, (int)info.x, (int)info.y, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            List list = SchlushWindowFrame.this.images;
            synchronized (list) {
                for (SchlushFrame.ImageInfo info : SchlushWindowFrame.this.images) {
                    this.paintImage(g, info);
                }
            }
            list = SchlushWindowFrame.this.drawers;
            synchronized (list) {
                for (Drawer drawer : SchlushWindowFrame.this.drawers) {
                    drawer.draw(g, SchlushWindowFrame.this.frame.getWidth(), SchlushWindowFrame.this.frame.getHeight(), SchlushWindowFrame.this.coordinate);
                }
            }
        }
    }
}

