/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.morilib.lisp.painter.ImageFactory;
import net.morilib.lisp.painter.ImagePainter;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.painter.geom.Point2D;

public class SchlushPainterFrame
extends ImagePainter
implements SchlushFrame {
    BufferedImage image;
    private CoordinateMap coordinate;
    private final ImageFactory factory = new ImageFactory(){

        @Override
        public Image getImage() {
            return SchlushPainterFrame.this.image;
        }
    };

    public SchlushPainterFrame(int x, int y, CoordinateMap coordinate) {
        this.image = new BufferedImage(x, y, 2);
        this.coordinate = coordinate;
    }

    @Override
    public void addImage(SchlushFrame.ImageInfo img) throws InterruptedException {
        Graphics2D g = this.image.createGraphics();
        if (this.coordinate != null) {
            Point2D p0 = this.coordinate.transform(this.image.getWidth(), this.image.getHeight(), img.x, img.y);
            Point2D ps = this.coordinate.transformSize(this.image.getWidth(), this.image.getHeight(), img.sx, img.sy);
            g.drawImage(img.img, p0.getXInt(), p0.getYInt() - ps.getYInt(), ps.getXInt(), ps.getYInt(), null);
        } else {
            g.drawImage(img.img, (int)img.x, (int)img.y, (int)img.sx, (int)img.sy, null);
        }
        g.dispose();
    }

    @Override
    public void addDrawer(Drawer drawer) {
        Graphics2D g = this.image.createGraphics();
        drawer.draw(g, this.image.getWidth(), this.image.getHeight(), this.coordinate);
        g.dispose();
    }

    @Override
    public int getImageWidth(Image img) {
        return img.getWidth(null);
    }

    @Override
    public int getImageHeight(Image img) {
        return img.getHeight(null);
    }

    @Override
    public ImageFactory getImageFactory() {
        return this.factory;
    }

    @Override
    public void clearScreen() {
        Graphics2D g = this.image.createGraphics();
        g.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
        g.dispose();
    }

    @Override
    public CoordinateMap getCoordinate() {
        return this.coordinate;
    }

    @Override
    public int getHeight() {
        return this.image.getHeight();
    }

    @Override
    public int getWidth() {
        return this.image.getWidth();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<painter-frame>");
    }
}

