/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.format;

import java.math.BigInteger;
import net.morilib.util.IntMath;

public final class FormatUtils {
    private FormatUtils() {
    }

    public static String pad(String src, int mincol, int colinc, int minpad, char padchar, boolean rightpad) {
        if (mincol < 0) {
            throw new IllegalArgumentException();
        }
        if (colinc < 1) {
            throw new IllegalArgumentException();
        }
        if (minpad < 0) {
            throw new IllegalArgumentException();
        }
        int padlen = IntMath.natsub(mincol, src.length());
        StringBuilder buf = new StringBuilder();
        if ((padlen = IntMath.tomult(padlen, colinc)) < minpad) {
            padlen = minpad;
        }
        if (!rightpad) {
            buf.append(src);
        }
        int i = 0;
        while (i < padlen) {
            buf.append(padchar);
            ++i;
        }
        if (rightpad) {
            buf.append(src);
        }
        return buf.toString();
    }

    private static void padComma(StringBuilder vstr, int sign0, char commachar, int commaintv) {
        int l0 = vstr.length();
        int i = vstr.length() - 1;
        while (i > sign0) {
            int l = l0 - i;
            if (l % commaintv == 0) {
                vstr.insert(i, commachar);
            }
            --i;
        }
    }

    public static String padInteger(BigInteger val, int mincol, char padchar, char commachar, int commaintv, boolean signp, int radix) {
        char c0;
        int sign0;
        if (mincol < 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder vstr = new StringBuilder(val.toString(radix));
        if (signp && val.signum() >= 0) {
            vstr.insert(0, '+');
        }
        int n = sign0 = (c0 = vstr.charAt(0)) == '+' || c0 == '-' ? 1 : 0;
        if (commaintv > 0 && padchar == '0') {
            int minlen;
            int nl0 = vstr.length();
            int rpt = minlen - nl0 + (((minlen = mincol - (mincol - 1) / commaintv) + 1) % commaintv == 0 ? 1 : 0);
            int i = 0;
            while (i < rpt) {
                vstr.insert(sign0, padchar);
                ++i;
            }
            FormatUtils.padComma(vstr, sign0, commachar, commaintv);
        } else if (padchar == '0') {
            int l0 = vstr.length();
            int i = 0;
            while (i < mincol - l0) {
                vstr.insert(sign0, padchar);
                ++i;
            }
        } else {
            if (commaintv > 0) {
                FormatUtils.padComma(vstr, sign0, commachar, commaintv);
            }
            int l0 = vstr.length();
            int i = 0;
            while (i < mincol - l0) {
                vstr.insert(0, padchar);
                ++i;
            }
        }
        return vstr.toString();
    }
}

