/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.exlib;

import net.morilib.lang.number.complex.ComplexDouble;
import net.morilib.lang.number.complex.RectanglarComplexDouble;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.math.special.GammaFunctions;

public class Gamma
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        LispNumber res;
        if (!(c1a instanceof LispNumber)) {
            throw mesg.getError("err.require.number", c1a);
        }
        LispNumber z0 = (LispNumber)c1a;
        if (z0.isReal()) {
            double r = GammaFunctions.gamma(z0.getRealDouble());
            res = new LispDouble(r);
        } else {
            ComplexDouble z = RectanglarComplexDouble.valueOf(z0.getRealDouble(), z0.getImagDouble());
            ComplexDouble r = GammaFunctions.gamma(z);
            res = LispComplex.newComplex(r.realPart(), r.imagPart());
        }
        return res;
    }
}

