/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.lisp.ParserSharpSyntax;
import net.morilib.lisp.RegexPattern;
import net.morilib.lisp.Symbol;

public class Parser {
    private static final Datum _VOID = new Datum(){};
    private static final Symbol _DOT = Symbol.getSymbol(".");
    private static final int EOF = -1;
    private LispMessage message;
    private PushbackReader rd = null;
    private State state;
    private StringBuilder buf = new StringBuilder();
    private StringBuilder buf2 = new StringBuilder();
    private Stack<Datum> resultStack = new Stack();
    private Stack<State> stateStack = new Stack();
    private Stack<Cons> consStack = new Stack();
    private Stack<List<Datum>> vectorStack = new Stack();
    private Stack<Integer> parenStack = new Stack();
    private boolean prefixed = false;
    private Exact exactness = Exact.DEFAULT;
    private int radix = -1;
    private boolean signed = false;
    private boolean readBefore = false;
    private boolean consoleMode;
    private Pattern REGEX_PAT = Pattern.compile("/(.*)/([iuc]*)");

    Parser(LispMessage msg) {
        this.message = msg;
        this.consoleMode = true;
        this.clear();
    }

    Parser(Environment env, LispMessage msg) {
        this.message = msg;
        this.consoleMode = true;
        this.clear();
    }

    Parser(PushbackReader read, LispMessage msg) {
        this.message = msg;
        this.consoleMode = false;
        this.rd = read;
        this.clear();
    }

    public Parser() {
        this(LispMessage.getInstance());
    }

    public Parser(Locale lc) {
        this(LispMessage.getInstance(lc));
    }

    public Parser(PushbackReader read) {
        this(read, LispMessage.getInstance());
    }

    public Parser(PushbackReader read, Locale lc) {
        this(read, LispMessage.getInstance(lc));
    }

    private void clearBuf() {
        this.buf = new StringBuilder();
        this.buf2 = new StringBuilder();
        this.prefixed = false;
        this.exactness = Exact.DEFAULT;
        this.radix = -1;
        this.signed = false;
    }

    private int read() throws IOException {
        int res = this.rd.read();
        if (res < 0) {
            return -1;
        }
        this.readBefore = true;
        return res;
    }

    private int readNext2() throws IOException {
        int res;
        while ((res = this.rd.read()) >= 0) {
            this.readBefore = true;
            if (Character.isWhitespace(res)) continue;
            return res;
        }
        return -1;
    }

    private int readNext() throws IOException {
        this.clearBuf();
        return this.readNext2();
    }

    private void appendBuf(int c) {
        this.buf.append((char)c);
    }

    private void appendBuf2(int c) {
        this.buf2.append((char)c);
    }

    private String getToken() {
        String res = this.buf.toString();
        return res;
    }

    private String getToken2() {
        String res = this.buf2.toString();
        return res;
    }

    private static double parseDouble(String str) {
        if ("+inf.0".equals(str)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-inf.0".equals(str)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("+nan.0".equals(str)) {
            return Double.NaN;
        }
        if ("-nan.0".equals(str)) {
            return Double.NaN;
        }
        return Double.parseDouble(str);
    }

    private double getValueByDouble(String str) {
        double i;
        String[] ind = str.split("/");
        if (ind.length == 2) {
            double n = Parser.parseDouble(ind[0]);
            double d = Parser.parseDouble(ind[1]);
            i = n / d;
        } else if (ind.length == 1) {
            i = Parser.parseDouble(ind[0]);
        } else {
            throw new RuntimeException("internal error");
        }
        return i;
    }

    private BigInteger getValueByBigInt(String str, int r) {
        return new BigInteger(str.replaceFirst("^\\+", ""), r);
    }

    private boolean isExpsym(int r) {
        return r == 101 || r == 69 || r == 115 || r == 83 || r == 102 || r == 70 || r == 100 || r == 68 || r == 108 || r == 76;
    }

    private boolean isDigit09az(int r) {
        return r >= 48 && r <= 57 || this.radix == 16 && (r >= 65 && r <= 70 || r >= 97 && r <= 102);
    }

    private boolean isDigit09(int r) {
        return r >= 48 && r <= 57;
    }

    private static String reverseNumFormat(Exact exactness, int radix) {
        String res = "";
        if (Exact.EXACT.equals((Object)exactness)) {
            res = String.valueOf(res) + "#e";
        } else if (Exact.INEXACT.equals((Object)exactness)) {
            res = String.valueOf(res) + "#i";
        }
        if (radix == 2) {
            res = String.valueOf(res) + "#b";
        } else if (radix == 8) {
            res = String.valueOf(res) + "#o";
        } else if (radix == 10) {
            res = String.valueOf(res) + "#d";
        } else if (radix == 16) {
            res = String.valueOf(res) + "#x";
        }
        return res;
    }

    private String reverseNumFormat() {
        return Parser.reverseNumFormat(this.exactness, this.radix);
    }

    private State symbolNum() {
        if (this.prefixed) {
            throw this.message.getReadError("err.read.format.numeric");
        }
        return State.SYMBOL;
    }

    private State symbol2Num() {
        if (this.prefixed) {
            throw this.message.getReadError("err.read.format.numeric");
        }
        return State.SYMBOL2;
    }

    private State popStateSymbolNum() {
        if (this.prefixed) {
            throw this.message.getReadError("err.read.format.numeric", String.valueOf(this.reverseNumFormat()) + this.getToken() + this.getToken2());
        }
        this.resultStack.push(this.getSymbol());
        return this.popStateStack();
    }

    private LispNumber getInteger() {
        String str = this.getToken();
        int r = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        try {
            BigInteger val = this.getValueByBigInt(str, r);
            LispReal atom = Exact.INEXACT.equals((Object)ex) ? new LispDouble(val.doubleValue()) : LispInteger.valueOf(val);
            return atom;
        }
        catch (NumberFormatException e) {
            throw this.message.getReadError("err.read.format.numeric", String.valueOf(Parser.reverseNumFormat(ex, this.radix)) + str);
        }
    }

    private LispNumber getRational() {
        String str = this.getToken();
        String[] nd = str.split("/");
        int r = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        try {
            BigInteger num = this.getValueByBigInt(nd[0], r);
            BigInteger den = this.getValueByBigInt(nd[1], r);
            if (Exact.INEXACT.equals((Object)ex)) {
                double numd = num.doubleValue();
                double dend = den.doubleValue();
                return new LispDouble(numd / dend);
            }
            return LispRational.newRational(num, den);
        }
        catch (NumberFormatException e) {
            throw this.message.getReadError("err.read.format.numeric", String.valueOf(Parser.reverseNumFormat(ex, r)) + str);
        }
    }

    private LispNumber getDouble() {
        String str = this.getToken();
        int r = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        if (r != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10", String.valueOf(Parser.reverseNumFormat(ex, r)) + str);
        }
        double val = Parser.parseDouble(str);
        LispDouble atom = new LispDouble(val);
        if (Exact.EXACT.equals((Object)ex)) {
            return atom.toExact();
        }
        return atom;
    }

    private LispNumber getImaginary() {
        String gtok1 = this.getToken();
        int r = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        if (r > 0 && r != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10", String.valueOf(Parser.reverseNumFormat(ex, r)) + gtok1);
        }
        String iii = gtok1.replaceFirst("i$", "");
        double i = "+".equals(iii) ? 1.0 : ("-".equals(iii) ? -1.0 : this.getValueByDouble(iii));
        return LispComplex.newComplex(0.0, i);
    }

    private LispNumber getComplex() {
        String gtok1 = this.getToken();
        String gtok2 = this.getToken2();
        int rx = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        if (rx > 0 && rx != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10", String.valueOf(Parser.reverseNumFormat(ex, rx)) + gtok1 + gtok2);
        }
        String iii = gtok2.replaceFirst("i$", "");
        double i = "+".equals(iii) ? 1.0 : ("-".equals(iii) ? -1.0 : this.getValueByDouble(iii));
        if (i != 0.0) {
            double r = this.getValueByDouble(gtok1);
            return LispComplex.newComplex(r, i);
        }
        if (gtok1.indexOf(47) > 0) {
            String[] nd = gtok1.split("/");
            BigInteger num = new BigInteger(nd[0]);
            BigInteger den = new BigInteger(nd[1]);
            this.clearBuf();
            return LispRational.newRational(num, den);
        }
        if (gtok1.matches("^[0-9]+$")) {
            BigInteger val = new BigInteger(gtok1);
            LispInteger atom = LispInteger.valueOf(val);
            this.clearBuf();
            return atom;
        }
        double val = Parser.parseDouble(gtok1);
        LispDouble atom = new LispDouble(val);
        this.clearBuf();
        return atom;
    }

    private LispNumber getPolar() {
        String str = this.getToken();
        int rx = this.radix < 0 ? 10 : this.radix;
        Exact ex = this.exactness;
        this.clearBuf();
        if (rx > 0 && rx != 10) {
            throw this.message.getReadError("err.read.notsupported.radix10", String.valueOf(Parser.reverseNumFormat(ex, rx)) + str);
        }
        String[] ra = str.split("@");
        double r = this.getValueByDouble(ra[0]);
        if (r == 0.0) {
            return new LispDouble(0.0);
        }
        double a = this.getValueByDouble(ra[1]);
        return LispComplex.newComplex(r * Math.cos(a), r * Math.sin(a));
    }

    private Datum getRegex() {
        String tok = this.getToken();
        Matcher mch = this.REGEX_PAT.matcher(tok);
        mch.find();
        String re = mch.group(1);
        String fl = mch.group(2);
        try {
            return new RegexPattern(re, fl);
        }
        catch (PatternSyntaxException e) {
            throw this.message.getReadError("err.read.regex.syntax", re);
        }
    }

    private LispCharacter getCharacter() {
        String str = this.getToken();
        this.clearBuf();
        if (str.length() == 1) {
            return new LispCharacter(str.charAt(0));
        }
        LispCharacter r = LispCharacter.getByName(str);
        if (r == null) {
            throw this.message.getReadError("err.read.character.unknown", str);
        }
        return r;
    }

    private LispString getString() {
        String str = this.getToken();
        this.clearBuf();
        return new LispString(str);
    }

    private Datum getSymbol() {
        String str = String.valueOf(this.getToken()) + this.getToken2();
        this.clearBuf();
        if ("+nan.0".equals(str)) {
            return LispDouble.NaN;
        }
        if (str.length() >= 2 && str.charAt(0) == ':') {
            return Keyword.getKeyword(str.substring(1));
        }
        return Symbol.getSymbol(str);
    }

    private Symbol getQuote() {
        String str = this.getToken();
        this.clearBuf();
        if ("'".equals(str)) {
            return Symbol.QUOTE;
        }
        if ("`".equals(str)) {
            return Symbol.QUASIQUOTE;
        }
        if (",".equals(str)) {
            return Symbol.UNQUOTE;
        }
        if (",@".equals(str)) {
            return Symbol.UNQUOTE_SPLICING;
        }
        throw new RuntimeException("unknown quote:" + str);
    }

    private State popStateStack() {
        State poped;
        while (true) {
            Datum dd;
            if (this.stateStack.empty()) {
                return State.INIT;
            }
            poped = this.stateStack.pop();
            if (State.QUOTE.equals((Object)poped)) {
                Datum c31 = this.resultStack.pop();
                Cons c32 = this.consStack.pop();
                if (c31 == _VOID) {
                    this.stateStack.push(poped);
                    this.consStack.push(c32);
                    return State.INIT;
                }
                c32.setCar(c31);
                continue;
            }
            if (State.S_EXP_COMMENT.equals((Object)poped)) {
                dd = this.resultStack.pop();
                if (_DOT.equals(dd)) {
                    throw this.message.getReadError("err.read.dot");
                }
                this.resultStack.push(_VOID);
                continue;
            }
            if (State.S_EXP_MACRO.equals((Object)poped)) {
                dd = this.resultStack.pop();
                Datum mt = this.resultStack.pop();
                Datum sy = this.resultStack.pop();
                Cons re = new Cons(sy, new Cons(mt, new Cons(dd, Nil.NIL)));
                this.resultStack.push(re);
                continue;
            }
            if (!State.S_EXP_QUOTE.equals((Object)poped)) break;
            dd = this.resultStack.pop();
            Datum sy = this.resultStack.pop();
            Cons re = new Cons(sy, new Cons(dd, Nil.NIL));
            this.resultStack.push(re);
        }
        return poped;
    }

    private void checkParenthesis(int r) {
        int p = this.parenStack.pop();
        if (!(p == 40 && r == 41 || p == 91 && r == 93)) {
            throw this.message.getReadError("err.read.parenthesis.mismatch");
        }
    }

    public boolean readParse(String exp) throws IOException {
        this.read(exp);
        return this.parse();
    }

    public void read(String read) {
        if (this.rd != null) {
            try {
                this.rd.close();
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
        this.rd = new PushbackReader(new StringReader(read));
    }

    public Datum getDatum() {
        while (!this.resultStack.empty() && this.resultStack.get(0) == _VOID) {
            this.resultStack.remove(0);
        }
        if (this.stateStack.empty() && !this.resultStack.empty()) {
            return (Datum)this.resultStack.get(0);
        }
        return null;
    }

    public List<Datum> getData() {
        return Collections.unmodifiableList(this.resultStack);
    }

    public boolean isReadBefore() {
        return this.readBefore;
    }

    private boolean isStackOK() {
        return this.stateStack.empty() || this.stateStack.size() == 1 && this.stateStack.peek().equals((Object)State.INIT);
    }

    public void clear() {
        this.resultStack.clear();
        this.stateStack.clear();
        this.consStack.clear();
        this.clearBuf();
        this.stateStack.push(State.INIT);
        this.state = State.INIT;
        this.readBefore = false;
    }

    public boolean parse() throws IOException {
        int r;
        if (this.rd == null) {
            throw new IllegalStateException();
        }
        if (this.stateStack.empty() && State.INIT.equals((Object)this.state)) {
            this.stateStack.push(State.INIT);
        }
        if (State.STRING.equals((Object)this.state)) {
            r = this.read();
        } else {
            this.readBefore = false;
            r = this.readNext();
        }
        ParserSharpSyntax.Engine eng = null;
        while (true) {
            if (!this.consoleMode && this.readBefore && this.stateStack.empty()) {
                if (r >= 0) {
                    this.rd.unread(r);
                }
                return true;
            }
            switch (this.state) {
                case INIT: {
                    if (r == 40 || r == 91) {
                        this.parenStack.push(r);
                        this.state = State.LIST;
                        r = this.readNext();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        throw this.message.getReadError("err.read.closeparenthesis");
                    }
                    if (r == 39 || r == 96 || r == 44) {
                        this.appendBuf(r);
                        this.state = State.QUOTE;
                        r = this.readNext2();
                        break;
                    }
                    if (r == 45 || r == 43) {
                        this.appendBuf(r);
                        this.state = State.HEAD_SIGN;
                        r = this.read();
                        break;
                    }
                    if (r == 34) {
                        this.state = State.STRING;
                        r = this.read();
                        break;
                    }
                    if (this.isDigit09(r)) {
                        this.appendBuf(r);
                        this.state = State.NUMBER;
                        r = this.read();
                        break;
                    }
                    if (r == 35) {
                        this.state = State.SHARP_SYNTAX_I;
                        r = this.read();
                        break;
                    }
                    if (r == -1) {
                        return this.isStackOK();
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        break;
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        break;
                    }
                    this.appendBuf(r);
                    this.state = State.SYMBOL;
                    r = this.read();
                    break;
                }
                case NUMBER_PREFIX: {
                    if (r == -1) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 35) {
                        r = this.read();
                        if (r == 101 || r == 69) {
                            if (!Exact.DEFAULT.equals((Object)this.exactness)) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.exactness = Exact.EXACT;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 105 || r == 73) {
                            if (!Exact.DEFAULT.equals((Object)this.exactness)) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.exactness = Exact.INEXACT;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 98 || r == 66) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 2;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 111 || r == 79) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 8;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 100 || r == 68) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 10;
                            this.state = State.NUMBER_PREFIX;
                        } else if (r == 120 || r == 88) {
                            if (this.radix > 0) {
                                throw this.message.getReadError("err.read.numberprefix");
                            }
                            this.radix = 16;
                            this.state = State.NUMBER_PREFIX;
                        }
                        r = this.read();
                        break;
                    }
                    if (r == 45 || r == 43) {
                        this.appendBuf(r);
                        this.state = State.HEAD_SIGN;
                        r = this.read();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        this.state = State.NUMBER;
                        r = this.read();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        break;
                    }
                    throw this.message.getReadError("err.read.numberprefix");
                }
                case HEAD_SIGN: {
                    this.signed = true;
                    if (this.isDigit09az(r)) {
                        this.state = State.NUMBER;
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.INF_I;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case NUMBER: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER;
                        r = this.read();
                        break;
                    }
                    if (this.isExpsym(r)) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E;
                        r = this.read();
                        break;
                    }
                    if (r == 40 || r == 91 || r == 91) {
                        this.resultStack.push(this.getInteger());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getInteger());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getInteger());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getInteger());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getInteger());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf(r);
                        this.state = State.RATIONAL_NUMBER;
                        r = this.read();
                        break;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        break;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_D;
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_D: {
                    if (r == -1) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    if (this.isExpsym(r)) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E;
                        r = this.read();
                        break;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        break;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_E: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E_SIGN;
                        r = this.read();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D;
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_E_SIGN: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D;
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_E_D: {
                    if (r == -1) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        break;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case RATIONAL_NUMBER: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.RATIONAL_NUMBER_2;
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case RATIONAL_NUMBER_2: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getRational());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getRational());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getRational());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getRational());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getRational());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        break;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case INIT_POLAR: {
                    if (r == 45 || r == 43) {
                        this.appendBuf(r);
                        this.state = State.HEAD_SIGN_POLAR;
                        r = this.read();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        this.state = State.NUMBER_POLAR;
                        r = this.read();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case HEAD_SIGN_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.state = State.NUMBER_POLAR;
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case NUMBER_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_POLAR;
                        r = this.read();
                        break;
                    }
                    if (this.isExpsym(r)) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E_POLAR;
                        r = this.read();
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf(r);
                        this.state = State.RATIONAL_NUMBER_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_POLAR: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_D_POLAR;
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_D_POLAR: {
                    if (r == -1) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    if (this.isExpsym(r)) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_E_POLAR: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf(r);
                        this.state = State.FLOAT_NUMBER_E_SIGN_POLAR;
                        r = this.read();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_POLAR;
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_E_SIGN_POLAR: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_POLAR;
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case FLOAT_NUMBER_E_D_POLAR: {
                    if (r == -1) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case RATIONAL_NUMBER_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        this.state = State.RATIONAL_NUMBER_2_POLAR;
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case RATIONAL_NUMBER_2_POLAR: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf(r);
                        r = this.read();
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getPolar());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case INF_I: {
                    if (r == -1) {
                        this.resultStack.push(this.getImaginary());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getImaginary());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getImaginary());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getImaginary());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getImaginary());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 110) {
                        this.appendBuf(r);
                        this.state = State.INF_N;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case INF_N: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 102) {
                        this.appendBuf(r);
                        this.state = State.INF_F;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case INF_F: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.INF_DOT;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case INF_DOT: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 48) {
                        this.appendBuf(r);
                        this.state = State.INF_0;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case INF_0: {
                    if (r == -1) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getDouble());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.HEAD_SIGN_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf(r);
                        this.state = State.COMPLEX_I;
                        r = this.read();
                        break;
                    }
                    if (r == 64) {
                        this.appendBuf(r);
                        this.state = State.INIT_POLAR;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case COMPLEX_I: {
                    if (r == 40 || r == 91) {
                        if (this.signed) {
                            this.resultStack.push(this.getImaginary());
                            this.state = this.popStateStack();
                            break;
                        }
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        if (this.signed) {
                            this.resultStack.push(this.getImaginary());
                            this.state = this.popStateStack();
                            break;
                        }
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        if (this.signed) {
                            this.resultStack.push(this.getImaginary());
                            this.state = this.popStateStack();
                            break;
                        }
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        if (this.signed) {
                            this.resultStack.push(this.getImaginary());
                            this.state = this.popStateStack();
                        } else {
                            this.state = this.popStateSymbolNum();
                        }
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        if (this.signed) {
                            this.resultStack.push(this.getImaginary());
                            this.state = this.popStateStack();
                        } else {
                            this.state = this.popStateSymbolNum();
                        }
                        return this.stateStack.empty();
                    }
                    this.state = this.symbolNum();
                    break;
                }
                case HEAD_SIGN_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.state = State.NUMBER_COMPLEX;
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf2(r);
                        this.state = State.INF_I_COMPLEX;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case NUMBER_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (this.isExpsym(r)) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_E_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf2(r);
                        this.state = State.RATIONAL_NUMBER_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case FLOAT_NUMBER_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_D_COMPLEX;
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case FLOAT_NUMBER_D_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        break;
                    }
                    if (this.isExpsym(r)) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_E_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case FLOAT_NUMBER_E_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 43 || r == 45) {
                        this.appendBuf2(r);
                        this.state = State.FLOAT_NUMBER_E_SIGN_COMPLEX;
                        r = this.read();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_COMPLEX;
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case FLOAT_NUMBER_E_SIGN_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.state = State.FLOAT_NUMBER_E_D_COMPLEX;
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case FLOAT_NUMBER_E_D_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case RATIONAL_NUMBER_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        this.state = State.RATIONAL_NUMBER_2_COMPLEX;
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case RATIONAL_NUMBER_2_COMPLEX: {
                    if (this.isDigit09az(r)) {
                        this.appendBuf2(r);
                        r = this.read();
                        break;
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 105) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case INF_I_COMPLEX: {
                    if (r == -1) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 110) {
                        this.appendBuf2(r);
                        this.state = State.INF_N_COMPLEX;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case INF_N_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 102) {
                        this.appendBuf2(r);
                        this.state = State.INF_F_COMPLEX;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case INF_F_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf2(r);
                        this.state = State.INF_DOT_COMPLEX;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case INF_DOT_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 48) {
                        this.appendBuf2(r);
                        this.state = State.INF_0_COMPLEX;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case INF_0_COMPLEX: {
                    if (r == -1) {
                        this.state = this.popStateSymbolNum();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (r == 59) {
                        this.state = this.popStateSymbolNum();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.state = this.popStateSymbolNum();
                        r = this.readNext();
                        break;
                    }
                    if (r == 105) {
                        this.appendBuf2(r);
                        this.state = State.COMPLEX_I2;
                        r = this.read();
                        break;
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case COMPLEX_I2: {
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getComplex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.state = this.symbol2Num();
                    break;
                }
                case STRING: {
                    if (r == -1) {
                        if (this.consoleMode) {
                            this.appendBuf(10);
                            return this.stateStack.empty();
                        }
                        throw this.message.getReadError("err.read.eof");
                    }
                    if (r == 34) {
                        this.resultStack.push(this.getString());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 92) {
                        this.state = State.STRING_ESCAPE;
                        r = this.read();
                        break;
                    }
                    this.appendBuf(r);
                    r = this.read();
                    break;
                }
                case STRING_ESCAPE: {
                    if (r == -1) {
                        if (this.consoleMode) {
                            this.state = State.STRING;
                            return this.stateStack.empty();
                        }
                        throw this.message.getReadError("err.read.eof");
                    }
                    this.appendBuf(r);
                    this.state = State.STRING;
                    r = this.read();
                    break;
                }
                case SHARP_SYNTAX_I: {
                    if (r == -1) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 40) {
                        this.state = State.VECTOR;
                        r = this.readNext();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 59) {
                        this.state = State.S_EXP_COMMENT;
                        r = this.readNext();
                        break;
                    }
                    if (r == 47) {
                        this.state = State.SHARP_SYNTAX;
                        eng = ParserSharpSyntax.getInstance().getEngine();
                        eng.go(r);
                        r = this.read();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    if (r == 124) {
                        this.stateStack.push(State.INIT);
                        this.state = State.BLOCK_COMMENT;
                        r = this.readNext();
                        break;
                    }
                    if (r == 92) {
                        this.state = State.CHARACTER_EXP;
                        r = this.read();
                        break;
                    }
                    if (r == 101 || r == 69) {
                        this.prefixed = true;
                        this.exactness = Exact.EXACT;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        break;
                    }
                    if (r == 105 || r == 73) {
                        this.prefixed = true;
                        this.exactness = Exact.INEXACT;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        break;
                    }
                    if (r == 98 || r == 66) {
                        this.prefixed = true;
                        this.radix = 2;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        break;
                    }
                    if (r == 111 || r == 79) {
                        this.prefixed = true;
                        this.radix = 8;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        break;
                    }
                    if (r == 100 || r == 68) {
                        this.prefixed = true;
                        this.radix = 10;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        break;
                    }
                    if (r == 120 || r == 88) {
                        this.prefixed = true;
                        this.radix = 16;
                        this.state = State.NUMBER_PREFIX;
                        r = this.read();
                        break;
                    }
                    this.state = State.SHARP_SYNTAX;
                    eng = ParserSharpSyntax.getInstance().getEngine();
                    eng.go(r);
                    r = this.read();
                    break;
                }
                case SHARP_SYNTAX: {
                    if (eng == null) {
                        throw new NullPointerException();
                    }
                    if (r == -1 || r == 40 || r == 91 || r == 41 || r == 93 || r == 59 || Character.isWhitespace(r)) {
                        if (eng.isMatch()) {
                            if (!eng.isFollowS() && !eng.isUseMatch()) {
                                this.resultStack.push(eng.getDatum());
                                this.state = this.popStateStack();
                                if (r == -1) {
                                    return this.stateStack.empty();
                                }
                            } else if (eng.isFollowS() && eng.isUseMatch()) {
                                this.resultStack.push(eng.getDatum());
                                this.resultStack.push(new LispString(eng.getMatchString()));
                                this.stateStack.add(State.S_EXP_MACRO);
                                this.state = State.INIT;
                                if (r == -1) {
                                    return this.stateStack.empty();
                                }
                            } else if (eng.isFollowS() && !eng.isUseMatch()) {
                                this.resultStack.push(eng.getDatum());
                                this.stateStack.add(State.S_EXP_QUOTE);
                                this.state = State.INIT;
                                if (r == -1) {
                                    return this.stateStack.empty();
                                }
                            } else {
                                LispString ls = new LispString(eng.getMatchString());
                                this.resultStack.push(new Cons(eng.getDatum(), new Cons(ls, Nil.NIL)));
                                this.state = this.popStateStack();
                                if (r == -1) {
                                    return this.stateStack.empty();
                                }
                            }
                            if (!Character.isWhitespace(r)) break;
                            r = this.readNext();
                            break;
                        }
                        if (r == -1 || eng.isDead()) {
                            throw this.message.getReadError("err.read.sharp.unknown");
                        }
                    }
                    if (eng.isDeadNext(r)) {
                        if (eng.isFollowS() && eng.isUseMatch()) {
                            this.resultStack.push(eng.getDatum());
                            this.resultStack.push(new LispString(eng.getMatchString()));
                            this.stateStack.add(State.S_EXP_MACRO);
                            this.state = State.INIT;
                            break;
                        }
                        if (eng.isFollowS() && !eng.isUseMatch()) {
                            this.resultStack.push(eng.getDatum());
                            this.stateStack.add(State.S_EXP_QUOTE);
                            this.state = State.INIT;
                            if (r != -1) break;
                            return this.stateStack.empty();
                        }
                    }
                    eng.go(r);
                    r = this.read();
                    break;
                }
                case SHARP_SYNTAX_RE: {
                    if (r == -1) {
                        this.resultStack.push(this.getRegex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 47) {
                        this.appendBuf(r);
                        this.state = State.SHARP_SYNTAX_RE_F;
                        r = this.read();
                        break;
                    }
                    this.appendBuf(r);
                    r = this.read();
                    break;
                }
                case SHARP_SYNTAX_RE_F: {
                    if (r == -1) {
                        this.resultStack.push(this.getRegex());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getRegex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getRegex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getRegex());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getRegex());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 92) {
                        throw this.message.getReadError("err.read.sharp.unknown");
                    }
                    this.appendBuf(r);
                    r = this.read();
                    break;
                }
                case CHARACTER_EXP: {
                    if (r == -1) {
                        throw this.message.getReadError("err.read.eol");
                    }
                    if (r == 59) {
                        throw this.message.getReadError("err.read.character.unknown");
                    }
                    this.appendBuf(r);
                    this.state = State.CHARACTER_EXP_NAME;
                    r = this.read();
                    break;
                }
                case CHARACTER_EXP_NAME: {
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getCharacter());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getCharacter());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getCharacter());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getCharacter());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getCharacter());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.appendBuf(r);
                    r = this.read();
                    break;
                }
                case SYMBOL: {
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.appendBuf(r);
                    r = this.read();
                    break;
                }
                case SYMBOL2: {
                    if (r == 40 || r == 91) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (r == 59) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == -1) {
                        this.resultStack.push(this.getSymbol());
                        this.state = this.popStateStack();
                        return this.stateStack.empty();
                    }
                    this.appendBuf2(r);
                    r = this.read();
                    break;
                }
                case LIST: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        break;
                    }
                    if (r == 41 || r == 93) {
                        this.checkParenthesis(r);
                        this.resultStack.push(Nil.NIL);
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    Cons n = new Cons(_VOID, Nil.NIL);
                    this.resultStack.push(n);
                    this.stateStack.push(State.LIST2);
                    this.consStack.push(n);
                    this.state = State.INIT;
                    break;
                }
                case LIST2: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        break;
                    }
                    Cons c1 = this.consStack.peek();
                    Datum d1 = this.resultStack.pop();
                    if (d1 != _VOID) {
                        c1.setCar(d1);
                    }
                    if (r == 41 || r == 93) {
                        Datum d2 = this.resultStack.pop();
                        this.checkParenthesis(r);
                        if (d2 instanceof Cons) {
                            Cons cd2 = (Cons)d2;
                            if (cd2.getCar() == _VOID) {
                                this.resultStack.push(Nil.NIL);
                            } else {
                                this.resultStack.push(d2);
                            }
                        } else {
                            throw new RuntimeException();
                        }
                        this.consStack.pop();
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 46) {
                        this.appendBuf(r);
                        this.state = State.LIST_DOT_INIT;
                        r = this.read();
                        break;
                    }
                    if (d1 != _VOID) {
                        Cons n = new Cons();
                        c1.setCdr(n);
                        this.consStack.pop();
                        this.consStack.push(n);
                    }
                    this.stateStack.push(State.LIST2);
                    this.state = State.INIT;
                    break;
                }
                case LIST_DOT_INIT: {
                    Cons n;
                    Cons c3 = this.consStack.peek();
                    if (c3.getCar() == _VOID) {
                        throw this.message.getReadError("err.read.list.invalid");
                    }
                    if (r == 40 || r == 91 || r == 41 || r == 93 || r == -1) {
                        this.stateStack.push(State.LIST_DOT);
                        this.state = State.INIT;
                        this.clearBuf();
                        c3.setCdr(_VOID);
                        break;
                    }
                    if (r == 59) {
                        this.stateStack.push(State.LIST_DOT);
                        this.stateStack.push(State.INIT);
                        this.state = State.COMMENT;
                        this.clearBuf();
                        c3.setCdr(_VOID);
                        break;
                    }
                    if (Character.isWhitespace(r)) {
                        this.stateStack.push(State.LIST_DOT);
                        this.state = State.INIT;
                        r = this.readNext();
                        c3.setCdr(_VOID);
                        break;
                    }
                    if (this.isDigit09(r)) {
                        n = new Cons();
                        c3.setCdr(n);
                        this.consStack.pop();
                        this.stateStack.push(State.LIST2);
                        this.consStack.push(n);
                        this.state = State.FLOAT_NUMBER_D;
                        break;
                    }
                    n = new Cons();
                    c3.setCdr(n);
                    this.consStack.pop();
                    this.stateStack.push(State.LIST2);
                    this.consStack.push(n);
                    this.state = State.SYMBOL;
                    break;
                }
                case LIST_DOT: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        break;
                    }
                    Cons c2 = this.consStack.peek();
                    Datum d1 = this.resultStack.pop();
                    if (d1 != _VOID) {
                        c2.setCdr(d1);
                    }
                    if (r == 41 || r == 93) {
                        this.checkParenthesis(r);
                        if (c2.getCdr() == _VOID) {
                            throw this.message.getReadError("err.read.dot");
                        }
                        this.consStack.pop();
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (d1 == _VOID) {
                        this.stateStack.push(State.LIST_DOT);
                        this.state = State.INIT;
                        this.clearBuf();
                        break;
                    }
                    throw this.message.getReadError("err.read.dot");
                }
                case QUOTE: {
                    Cons n1 = new Cons();
                    Cons n2 = new Cons();
                    if (r == 64) {
                        this.appendBuf(r);
                        r = this.readNext2();
                    }
                    n1.setCar(this.getQuote());
                    n1.setCdr(n2);
                    this.resultStack.push(n1);
                    this.consStack.push(n2);
                    this.stateStack.push(State.QUOTE);
                    this.state = State.INIT;
                    break;
                }
                case VECTOR: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 41) {
                        this.resultStack.push(LispVector.EMPTY);
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 93) {
                        throw this.message.getReadError("err.read.parenthesis.mismatch");
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        break;
                    }
                    this.vectorStack.push(new ArrayList());
                    this.stateStack.push(State.VECTOR2);
                    this.state = State.INIT;
                    break;
                }
                case VECTOR2: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 59) {
                        this.stateStack.push(this.state);
                        this.state = State.COMMENT;
                        r = this.read();
                        break;
                    }
                    List<Datum> v1 = this.vectorStack.peek();
                    Datum d1 = this.resultStack.pop();
                    if (d1 != _VOID) {
                        v1.add(d1);
                    }
                    if (r == 41) {
                        this.vectorStack.pop();
                        this.resultStack.push(new LispVector(v1));
                        this.state = this.popStateStack();
                        r = this.readNext();
                        break;
                    }
                    if (r == 93) {
                        throw this.message.getReadError("err.read.parenthesis.mismatch");
                    }
                    this.stateStack.push(State.VECTOR2);
                    this.state = State.INIT;
                    break;
                }
                case COMMENT: {
                    if (r == -1) {
                        this.state = this.stateStack.pop();
                        break;
                    }
                    if (r == 10) {
                        this.state = this.stateStack.pop();
                        r = this.readNext();
                        break;
                    }
                    r = this.read();
                    break;
                }
                case BLOCK_COMMENT: {
                    if (r == -1) {
                        return this.stateStack.empty();
                    }
                    if (r == 124) {
                        r = this.read();
                        if (r == 35) {
                            this.state = this.stateStack.pop();
                            r = this.readNext();
                            break;
                        }
                        r = this.readNext();
                        break;
                    }
                    if (r == 35) {
                        r = this.read();
                        if (r == 124) {
                            this.stateStack.push(State.BLOCK_COMMENT);
                            r = this.readNext();
                            break;
                        }
                        r = this.readNext();
                        break;
                    }
                    r = this.readNext();
                    break;
                }
                case S_EXP_COMMENT: {
                    this.stateStack.push(State.S_EXP_COMMENT);
                    this.state = State.INIT;
                }
            }
        }
    }

    private static enum Exact {
        DEFAULT,
        EXACT,
        INEXACT;

    }

    private static enum State {
        INIT,
        NUMBER_PREFIX,
        HEAD_SIGN,
        NUMBER,
        FLOAT_NUMBER,
        FLOAT_NUMBER_D,
        FLOAT_NUMBER_E,
        FLOAT_NUMBER_E_SIGN,
        FLOAT_NUMBER_E_D,
        RATIONAL_NUMBER,
        RATIONAL_NUMBER_2,
        INF_I,
        INF_N,
        INF_F,
        INF_DOT,
        INF_0,
        COMPLEX_I,
        INIT_POLAR,
        HEAD_SIGN_POLAR,
        NUMBER_POLAR,
        FLOAT_NUMBER_POLAR,
        FLOAT_NUMBER_D_POLAR,
        FLOAT_NUMBER_E_POLAR,
        FLOAT_NUMBER_E_SIGN_POLAR,
        FLOAT_NUMBER_E_D_POLAR,
        RATIONAL_NUMBER_POLAR,
        RATIONAL_NUMBER_2_POLAR,
        HEAD_SIGN_COMPLEX,
        NUMBER_COMPLEX,
        FLOAT_NUMBER_COMPLEX,
        FLOAT_NUMBER_D_COMPLEX,
        FLOAT_NUMBER_E_COMPLEX,
        FLOAT_NUMBER_E_SIGN_COMPLEX,
        FLOAT_NUMBER_E_D_COMPLEX,
        RATIONAL_NUMBER_COMPLEX,
        RATIONAL_NUMBER_2_COMPLEX,
        INF_I_COMPLEX,
        INF_N_COMPLEX,
        INF_F_COMPLEX,
        INF_DOT_COMPLEX,
        INF_0_COMPLEX,
        COMPLEX_I2,
        STRING,
        STRING_ESCAPE,
        SHARP_SYNTAX_I,
        SHARP_SYNTAX,
        SHARP_SYNTAX_RE,
        SHARP_SYNTAX_RE_F,
        CHARACTER_EXP,
        CHARACTER_EXP_NAME,
        SYMBOL,
        SYMBOL2,
        LIST,
        LIST2,
        LIST_DOT_INIT,
        LIST_DOT,
        QUOTE,
        VECTOR,
        VECTOR2,
        COMMENT,
        BLOCK_COMMENT,
        S_EXP_COMMENT,
        S_EXP_MACRO,
        S_EXP_QUOTE;

    }
}

