/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.sos.LispType;

public abstract class LispReal
extends LispNumber
implements Comparable<LispReal> {
    @Override
    public LispReal getReal() {
        return this;
    }

    @Override
    public double getImagDouble() {
        return 0.0;
    }

    @Override
    public LispReal getImag() {
        if (this.isNaN()) {
            return LispDouble.NaN;
        }
        if (this.isExact()) {
            return LispInteger.ZERO;
        }
        return LispDouble.ZERO;
    }

    @Override
    public int compareTo(LispReal o) {
        return this.isLessThan(o) ? -1 : (this.isMoreThan(o) ? 1 : 0);
    }

    public abstract boolean isLessThan(LispReal var1);

    public abstract boolean isMoreThan(LispReal var1);

    public abstract int signum();

    @Override
    public LispType getType() {
        return LispType.REAL;
    }
}

